/*
CGI.h
*/

#ifndef __CGI_H
#define __CGI_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Config.h"
#include "Utils.h"
#include "cgi-llist.h"
#include "cgi-lib.h"

class CGI
  {
  private:
    llist entries, cookies;
    char *SEP_CGI_VAR, *THEPATH_INFO, *stservice, *stcmd, *stsubcmd, *stlang, *user, *connid, 
         *validator, *pageid, *lastcmd, *beginmailbox, 
         *parm1, *parm2, *parm3, *parm4;
    int CodeUpload, Num_Cookies;
    void Parse_PATH_INFO (const char *apath);
  public:
    CGI (const char *UPLOADBASEDIRATTACHS, const char *aSEP_CGI_VAR);
    virtual ~CGI ();
    int getCodeUpload (void);
    char *GetEntry (const char *name);
    const char *GetMultipleEntries (const char *name, const char *SEP);    
    const char *GetEntryDef (const char *name, const char *def);
    bool IsNullEntry (const char *name);
    bool GetEntryBool (const char *name);
    const char *get_REMOTE_ADDR (const char *def);
    const char *get_PATHINFO (void);    
    const char *get_USERAGENT (void);
    const char *get_COOKIE (void);
    void PrintAllEntries(void);    
    int getNumCookies (void);
    const char *get_Cookie (const char *id);
    const char *getCmd (void);
    const char *getSubCmd (void);
    const char *getLang (void);
    const char *getService(void);
    const char *getUser (void);
    const char *getConnid (void);
    const char *getValidator(void);
    const char *getPageId(void);
    const char *getLastCmd(void);
    const char *getParm1 (void);
    const char *getParm2 (void);
    const char *getParm3 (void);
    const char *getParm4 (void);    
    const char *Env2File (void);
  };

#endif
