/*
Authentication.h
*/

#ifndef __AUTHENTICATION_H
#define __AUTHENTICATION_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <db1/db.h>

#include "Utils.h"
#include "Config.h"
#include "Configuration.h"
#include "XString.h"
#include "XVector.h"
#include "Cookie.h"
#include "CCLIENT.h"

typedef XVector<XString> StringList;

class Authentication
  {
  private:
    XString username, password, tmp_password, service, server;
    int iservice, port;
    Cookie *cookie;
    bool IS_AUTHENTICATED;
    bool imap_authentication (void);
    void do_store_password (void);
  public:
    Authentication (const char *aservice, const char *aserver, int aport, const char *ausername, const char *apassword, const char *connid);
    virtual ~Authentication ();
    bool doFirstAuthentication (void);  
    const char *cookie_getSetFullCookieLine (void);
    const char *cookie_getSetClearFullCookieLine(void);    
    bool isGoodCookie (const char *acookie);
  };

#endif

