(*
    Copyright (c) 2000
        Cambridge University Technical Services Limited

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
    
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*)


signature XM_TYPES = sig
include MOTIF_TYPES ;
exception XmNaccelerator                   of string ;
exception XmNacceleratorText               of XmString ;
exception XmNaccelerators                  of XtAccelerators ;
exception XmNadjustLast                    of bool ;
exception XmNadjustMargin                  of bool ;
exception XmNalignment                     of XmAlignment ;
exception XmNallowOverlap                  of bool ;
exception XmNallowResize                   of bool ;
exception XmNallowShellResize              of bool ;
exception XmNancestorSensitive             of bool ;
exception XmNapplyLabelString              of XmString ;
exception XmNargc                          of int ;
exception XmNargv                          of string list ;
exception XmNarmColor                      of int ;
exception XmNarmPixmap                     of XWindows.Drawable ;
exception XmNarrowDirection                of XmArrowDirection ;
exception XmNautoShowCursorPosition        of bool ;
exception XmNautoUnmanage                  of bool ;
exception XmNautomaticSelection            of bool ;
exception XmNbackground                    of int ;
exception XmNbackgroundPixmap              of XWindows.Drawable ;
exception XmNbaseHeight                    of int ;
exception XmNbaseWidth                     of int ;
exception XmNblinkRate                     of int ;
exception XmNborderColor                   of int ;
exception XmNborderPixmap                  of XWindows.Drawable ;
exception XmNborderWidth                   of int ;
exception XmNbottomAttachment              of XmAttachment ;
exception XmNbottomOffset                  of int ;
exception XmNbottomPosition                of int ;
exception XmNbottomShadowColor             of int ;
exception XmNbottomShadowPixmap            of XWindows.Drawable ;
exception XmNbottomWidget                  of Widget ;
exception XmNbuttonAcceleratorText         of XmString list ;
exception XmNbuttonAccelerators            of string list ;
exception XmNbuttonCount                   of int ;
exception XmNbuttonFontList                of (XWindows.XFontStruct * string) list ;
exception XmNbuttonMnemonicCharSets        of XmString list ;
exception XmNbuttonMnemonics               of int list ;
exception XmNbuttonSet                     of int ;
exception XmNbuttonType                    of XmButtonType list ;
exception XmNbuttons                       of XmString list ;
exception XmNcancelButton                  of Widget ;
exception XmNcancelLabelString             of XmString ;
exception XmNcascadePixmap                 of XWindows.Drawable ;
exception XmNchildren                      of Widget list ;
exception XmNclipWindow                    of Widget ;
exception XmNcolormap                      of XWindows.Colormap ;
exception XmNcolumns                       of int ;
exception XmNcommand                       of XmString ;
exception XmNcommandWindow                 of Widget ;
exception XmNcommandWindowLocation         of XmCommandWindowLocation ;
exception XmNcursorPosition                of int ;
exception XmNcursorPositionVisible         of bool ;
exception XmNdecimalPoints                 of int ;
exception XmNdefaultButton                 of Widget ;
exception XmNdefaultButtonShadowThickness  of int ;
exception XmNdefaultButtonType             of XmDefaultButtonType ;
exception XmNdefaultFontList               of (XWindows.XFontStruct * string) list ;
exception XmNdefaultPosition               of bool ;
exception XmNdeleteResponse                of XmDeleteResponse ;
exception XmNdepth                         of int ;
exception XmNdialogStyle                   of XmDialogStyle ;
exception XmNdialogTitle                   of XmString ;
exception XmNdialogType                    of XmDialogType ;
exception XmNdirListItemCount              of int ;
exception XmNdirListItems                  of XmString list ;
exception XmNdirListLabelString            of XmString ;
exception XmNdirMask                       of XmString ;
exception XmNdirSpec                       of XmString ;
exception XmNdirectory                     of XmString ;
exception XmNdirectoryValid                of bool ;
exception XmNdoubleClickInterval           of int ;
exception XmNeditMode                      of XmEditMode ;
exception XmNeditable                      of bool ;
exception XmNentryAlignment                of XmAlignment ;
exception XmNentryBorder                   of int ;
exception XmNfileListItemCount             of int ;
exception XmNfileListItems                 of XmString list ;
exception XmNfileListLabelString           of XmString ;
exception XmNfileTypeMask                  of XmFileTypeMask ;
exception XmNfillOnArm                     of bool ;
exception XmNfillOnSelect                  of bool ;
exception XmNfilterLabelString             of XmString ;
exception XmNfontList                      of (XWindows.XFontStruct * string) list ;
exception XmNforeground                    of int ;
exception XmNfractionBase                  of int ;
exception XmNgeometry                      of string ;
exception XmNheight                        of int ;
exception XmNheightInc                     of int ;
exception XmNhelpLabelString               of XmString ;
exception XmNhighlightColor                of int ;
exception XmNhighlightOnEnter              of bool ;
exception XmNhighlightPixmap               of XWindows.Drawable ;
exception XmNhighlightThickness            of int ;
exception XmNhistoryItemCount              of int ;
exception XmNhistoryItems                  of XmString list ;
exception XmNhistoryMaxItems               of int ;
exception XmNhistoryVisibleItemCount       of int ;
exception XmNhorizontalScrollBar           of Widget ;
exception XmNhorizontalSpacing             of int ;
exception XmNiconMask                      of XWindows.Drawable ;
exception XmNiconName                      of string ;
exception XmNiconNameEncoding              of int ;
exception XmNiconPixmap                    of XWindows.Drawable ;
exception XmNiconWindow                    of XWindows.Drawable ;
exception XmNiconX                         of int ;
exception XmNiconY                         of int ;
exception XmNiconic                        of bool ;
exception XmNincrement                     of int ;
exception XmNindicatorOn                   of bool ;
exception XmNindicatorSize                 of int ;
exception XmNindicatorType                 of XmIndicatorType ;
exception XmNinitialDelay                  of int ;
exception XmNinitialResourcesPersistent    of bool ;
exception XmNinitialState                  of XWindows.XWMStateHint ;
exception XmNinput                         of bool ;
exception XmNisAligned                     of bool ;
exception XmNisHomogeneous                 of bool ;
exception XmNitemCount                     of int ;
exception XmNitems                         of XmString list ;
exception XmNkeyboardFocusPolicy           of XmKeyboardFocusPolicy ;
exception XmNlabelFontList                 of (XWindows.XFontStruct * string) list ;
exception XmNlabelInsensitivePixmap        of XWindows.Drawable ;
exception XmNlabelPixmap                   of XWindows.Drawable ;
exception XmNlabelString                   of XmString ;
exception XmNlabelType                     of XmLabelType ;
exception XmNleftAttachment                of XmAttachment ;
exception XmNleftOffset                    of int ;
exception XmNleftPosition                  of int ;
exception XmNleftWidget                    of Widget ;
exception XmNlistItemCount                 of int ;
exception XmNlistItems                     of XmString list ;
exception XmNlistLabelString               of XmString ;
exception XmNlistMarginHeight              of int ;
exception XmNlistMarginWidth               of int ;
exception XmNlistSizePolicy                of XmVisualPolicy ;
exception XmNlistSpacing                   of int ;
exception XmNlistUpdated                   of bool ;
exception XmNlistVisibleItemCount          of int ;
exception XmNmainWindowMarginHeight        of int ;
exception XmNmainWindowMarginWidth         of int ;
exception XmNmappedWhenManaged             of bool ;
exception XmNmappingDelay                  of int ;
exception XmNmargin                        of int ;
exception XmNmarginBottom                  of int ;
exception XmNmarginHeight                  of int ;
exception XmNmarginLeft                    of int ;
exception XmNmarginRight                   of int ;
exception XmNmarginTop                     of int ;
exception XmNmarginWidth                   of int ;
exception XmNmaxAspectX                    of int ;
exception XmNmaxAspectY                    of int ;
exception XmNmaxHeight                     of int ;
exception XmNmaxLength                     of int ;
exception XmNmaxWidth                      of int ;
exception XmNmaximum                       of int ;
exception XmNmenuAccelerator               of string ;
exception XmNmenuBar                       of Widget ;
exception XmNmenuCursor                    of XWindows.Cursor ;
exception XmNmenuHelpWidget                of Widget ;
exception XmNmenuHistory                   of Widget ;
exception XmNmenuPost                      of string ;
exception XmNmessageAlignment              of XmAlignment ;
exception XmNmessageString                 of XmString ;
exception XmNmessageWindow                 of Widget ;
exception XmNminAspectX                    of int ;
exception XmNminAspectY                    of int ;
exception XmNminHeight                     of int ;
exception XmNminWidth                      of int ;
exception XmNminimizeButtons               of bool ;
exception XmNminimum                       of int ;
exception XmNmnemonic                      of int ;
exception XmNmnemonicCharSet               of string ;
exception XmNmultiClick                    of XmMultiClickType ;
exception XmNmustMatch                     of bool ;
exception XmNmwmDecorations                of int ;
exception XmNmwmFunctions                  of int ;
exception XmNmwmInputMode                  of int ;
exception XmNmwmMenu                       of string ;
exception XmNnavigationType                of XmNavigationType ;
exception XmNnoMatchString                 of XmString ;
exception XmNnoResize                      of bool ;
exception XmNnumChildren                   of int ;
exception XmNnumColumns                    of int ;
exception XmNokLabelString                 of XmString ;
exception XmNoptionLabel                   of XmString ;
exception XmNoptionMnemonic                of int ;
exception XmNorientation                   of XmOrientation ;
exception XmNoverrideRedirect              of bool ;
exception XmNpacking                       of XmPacking ;
exception XmNpageIncrement                 of int ;
exception XmNpaneMaximum                   of int ;
exception XmNpaneMinimum                   of int ;
exception XmNpattern                       of XmString ;
exception XmNpendingDelete                 of bool ;
exception XmNpopupEnabled                  of bool ;
exception XmNpostFromButton                of int ;
exception XmNprocessingDirection           of XmProcessingDirection ;
exception XmNpromptString                  of XmString ;
exception XmNpushButtonEnabled             of bool ;
exception XmNradioAlwaysOne                of bool ;
exception XmNradioBehavior                 of bool ;
exception XmNrecomputeSize                 of bool ;
exception XmNrefigureMode                  of bool ;
exception XmNrepeatDelay                   of int ;
exception XmNresizable                     of bool ;
exception XmNresizeHeight                  of bool ;
exception XmNresizePolicy                  of XmResizePolicy ;
exception XmNresizeWidth                   of bool ;
exception XmNrightAttachment               of XmAttachment ;
exception XmNrightOffset                   of int ;
exception XmNrightPosition                 of int ;
exception XmNrightWidget                   of Widget ;
exception XmNrowColumnType                 of XmRowColumnType ;
exception XmNrows                          of int ;
exception XmNrubberPositioning             of bool ;
exception XmNsashHeight                    of int ;
exception XmNsashIndent                    of int ;
exception XmNsashShadowThickness           of int ;
exception XmNsashWidth                     of int ;
exception XmNsaveUnder                     of bool ;
exception XmNscaleHeight                   of int ;
exception XmNscaleMultiple                 of int ;
exception XmNscaleWidth                    of int ;
exception XmNscrollBarDisplayPolicy        of XmScrollBarDisplayPolicy ;
exception XmNscrollBarPlacement            of XmScrollBarPlacement ;
exception XmNscrollHorizontal              of bool ;
exception XmNscrollLeftSide                of bool ;
exception XmNscrollTopSide                 of bool ;
exception XmNscrollVertical                of bool ;
exception XmNscrolledWindowMarginHeight    of int ;
exception XmNscrolledWindowMarginWidth     of int ;
exception XmNscrollingPolicy               of XmScrollingPolicy ;
exception XmNselectColor                   of int ;
exception XmNselectInsensitivePixmap       of XWindows.Drawable ;
exception XmNselectPixmap                  of XWindows.Drawable ;
exception XmNselectThreshold               of int ;
exception XmNselectedItemCount             of int ;
exception XmNselectedItems                 of XmString list ;
exception XmNselectionArray                of XmTextScanType list ;
exception XmNselectionArrayCount           of int ;
exception XmNselectionLabelString          of XmString ;
exception XmNselectionPolicy               of XmSelectionPolicy ;
exception XmNsensitive                     of bool ;
exception XmNseparatorOn                   of bool ;
exception XmNseparatorType                 of XmShadowType ;
exception XmNset                           of bool ;
exception XmNshadowThickness               of int ;
exception XmNshadowType                    of XmShadowType ;
exception XmNshellUnitType                 of XmUnitType ;
exception XmNshowArrows                    of bool ;
exception XmNshowAsDefault                 of int ;
exception XmNshowSeparator                 of bool ;
exception XmNshowValue                     of bool ;
exception XmNskipAdjust                    of bool ;
exception XmNsliderSize                    of int ;
exception XmNspacing                       of int ;
exception XmNstringDirection               of XmStringDirection ;
exception XmNsubMenuId                     of Widget ;
exception XmNsymbolPixmap                  of XWindows.Drawable ;
exception XmNtextAccelerators              of XtAccelerators ;
exception XmNtextColumns                   of int ;
exception XmNtextFontList                  of (XWindows.XFontStruct * string) list ;
exception XmNtextString                    of XmString ;
exception XmNtextTranslations              of XtTranslations ;
exception XmNtitle                         of string ;
exception XmNtitleEncoding                 of int ;
exception XmNtitleString                   of XmString ;
exception XmNtopAttachment                 of XmAttachment ;
exception XmNtopCharacter                  of int ;
exception XmNtopItemPosition               of int ;
exception XmNtopOffset                     of int ;
exception XmNtopPosition                   of int ;
exception XmNtopShadowColor                of int ;
exception XmNtopShadowPixmap               of XWindows.Drawable ;
exception XmNtopWidget                     of Widget ;
exception XmNtransient                     of bool ;
exception XmNtransientFor                  of Widget ;
exception XmNtranslations                  of XtTranslations ;
exception XmNtraversalOn                   of bool ;
exception XmNtroughColor                   of int ;
exception XmNunitType                      of XmUnitType ;
exception XmNuseAsyncGeometry              of bool ;
exception XmNvalue                         of int ;
exception XmNverifyBell                    of bool ;
exception XmNverticalScrollBar             of Widget ;
exception XmNverticalSpacing               of int ;
exception XmNvisibleItemCount              of int ;
exception XmNvisibleWhenOff                of bool ;
exception XmNvisual                        of XWindows.Visual ;
exception XmNvisualPolicy                  of XmVisualPolicy ;
exception XmNwaitForWm                     of bool ;
exception XmNwidth                         of int ;
exception XmNwidthInc                      of int ;
exception XmNwinGravity                    of int ;
exception XmNwindowGroup                   of XWindows.Drawable ;
exception XmNwmTimeout                     of int ;
exception XmNwordWrap                      of bool ;
exception XmNworkWindow                    of Widget ;
exception XmNx                             of int ;
exception XmNy                             of int ;
val XmCAccelerator:                  string ;
val XmCAcceleratorText:              string ;
val XmCAccelerators:                 string ;
val XmCAdjustLast:                   string ;
val XmCAdjustMargin:                 string ;
val XmCAlignment:                    string ;
val XmCAllowOverlap:                 string ;
val XmCAllowShellResize:             string ;
val XmCApplyLabelString:             string ;
val XmCArgc:                         string ;
val XmCArgv:                         string ;
val XmCArmColor:                     string ;
val XmCArmPixmap:                    string ;
val XmCArrowDirection:               string ;
val XmCAttachment:                   string ;
val XmCAutoShowCursorPosition:       string ;
val XmCAutoUnmanage:                 string ;
val XmCAutomaticSelection:           string ;
val XmCBackground:                   string ;
val XmCBackgroundPixmap:             string ;
val XmCBaseHeight:                   string ;
val XmCBaseWidth:                    string ;
val XmCBlinkRate:                    string ;
val XmCBoolean:                      string ;
val XmCBorderColor:                  string ;
val XmCBorderWidth:                  string ;
val XmCBottomShadowColor:            string ;
val XmCBottomShadowPixmap:           string ;
val XmCButtonAcceleratorText:        string ;
val XmCButtonAccelerators:           string ;
val XmCButtonCount:                  string ;
val XmCButtonFontList:               string ;
val XmCButtonMnemonicCharSets:       string ;
val XmCButtonMnemonics:              string ;
val XmCButtonSet:                    string ;
val XmCButtonType:                   string ;
val XmCButtons:                      string ;
val XmCCancelLabelString:            string ;
val XmCChildren:                     string ;
val XmCClipWindow:                   string ;
val XmCColormap:                     string ;
val XmCColumns:                      string ;
val XmCCommandWindow:                string ;
val XmCCommandWindowLocation:        string ;
val XmCCursor:                       string ;
val XmCCursorPosition:               string ;
val XmCCursorPositionVisible:        string ;
val XmCDecimalPoints:                string ;
val XmCDefaultButtonShadowThickness: string ;
val XmCDefaultButtonType:            string ;
val XmCDefaultFontList:              string ;
val XmCDefaultPosition:              string ;
val XmCDeleteResponse:               string ;
val XmCDepth:                        string ;
val XmCDialogStyle:                  string ;
val XmCDialogTitle:                  string ;
val XmCDialogType:                   string ;
val XmCDirListItemCount:             string ;
val XmCDirListItems:                 string ;
val XmCDirListLabelString:           string ;
val XmCDirMask:                      string ;
val XmCDirSpec:                      string ;
val XmCDirectory:                    string ;
val XmCDirectoryValid:               string ;
val XmCDoubleClickInterval:          string ;
val XmCEditMode:                     string ;
val XmCEditable:                     string ;
val XmCEntryBorder:                  string ;
val XmCFileListItemCount:            string ;
val XmCFileListItems:                string ;
val XmCFileListLabelString:          string ;
val XmCFileTypeMask:                 string ;
val XmCFillOnArm:                    string ;
val XmCFillOnSelect:                 string ;
val XmCFilterLabelString:            string ;
val XmCFontList:                     string ;
val XmCForeground:                   string ;
val XmCFraction:                     string ;
val XmCGeometry:                     string ;
val XmCHeight:                       string ;
val XmCHeightInc:                    string ;
val XmCHelpLabelString:              string ;
val XmCHighlightColor:               string ;
val XmCHighlightOnEnter:             string ;
val XmCHighlightPixmap:              string ;
val XmCHighlightThickness:           string ;
val XmCHorizontalScrollBar:          string ;
val XmCIconMask:                     string ;
val XmCIconName:                     string ;
val XmCIconNameEncoding:             string ;
val XmCIconPixmap:                   string ;
val XmCIconWindow:                   string ;
val XmCIconX:                        string ;
val XmCIconY:                        string ;
val XmCIconic:                       string ;
val XmCIncrement:                    string ;
val XmCIndicatorOn:                  string ;
val XmCIndicatorSize:                string ;
val XmCIndicatorType:                string ;
val XmCInitialDelay:                 string ;
val XmCInitialResourcesPersistent:   string ;
val XmCInitialState:                 string ;
val XmCInput:                        string ;
val XmCIsAligned:                    string ;
val XmCIsHomogeneous:                string ;
val XmCItemCount:                    string ;
val XmCItems:                        string ;
val XmCKeyboardFocusPolicy:          string ;
val XmCLabelFontList:                string ;
val XmCLabelInsensitivePixmap:       string ;
val XmCLabelPixmap:                  string ;
val XmCLabelString:                  string ;
val XmCLabelType:                    string ;
val XmCListLabelString:              string ;
val XmCListMarginHeight:             string ;
val XmCListMarginWidth:              string ;
val XmCListSizePolicy:               string ;
val XmCListSpacing:                  string ;
val XmCListUpdated:                  string ;
val XmCMainWindowMarginHeight:       string ;
val XmCMainWindowMarginWidth:        string ;
val XmCMappedWhenManaged:            string ;
val XmCMappingDelay:                 string ;
val XmCMargin:                       string ;
val XmCMarginBottom:                 string ;
val XmCMarginHeight:                 string ;
val XmCMarginLeft:                   string ;
val XmCMarginRight:                  string ;
val XmCMarginTop:                    string ;
val XmCMarginWidth:                  string ;
val XmCMaxAspectX:                   string ;
val XmCMaxAspectY:                   string ;
val XmCMaxHeight:                    string ;
val XmCMaxItems:                     string ;
val XmCMaxLength:                    string ;
val XmCMaxWidth:                     string ;
val XmCMaximum:                      string ;
val XmCMenuBar:                      string ;
val XmCMenuPost:                     string ;
val XmCMenuWidget:                   string ;
val XmCMessageString:                string ;
val XmCMessageWindow:                string ;
val XmCMinAspectX:                   string ;
val XmCMinAspectY:                   string ;
val XmCMinHeight:                    string ;
val XmCMinWidth:                     string ;
val XmCMinimizeButtons:              string ;
val XmCMinimum:                      string ;
val XmCMnemonic:                     string ;
val XmCMnemonicCharSet:              string ;
val XmCMultiClick:                   string ;
val XmCMustMatch:                    string ;
val XmCMwmDecorations:               string ;
val XmCMwmFunctions:                 string ;
val XmCMwmInputMode:                 string ;
val XmCMwmMenu:                      string ;
val XmCNavigationType:               string ;
val XmCNoMatchString:                string ;
val XmCNoResize:                     string ;
val XmCNumChildren:                  string ;
val XmCNumColumns:                   string ;
val XmCOffset:                       string ;
val XmCOkLabelString:                string ;
val XmCOptionLabel:                  string ;
val XmCOptionMnemonic:               string ;
val XmCOrientation:                  string ;
val XmCOverrideRedirect:             string ;
val XmCPacking:                      string ;
val XmCPageIncrement:                string ;
val XmCPaneMaximum:                  string ;
val XmCPaneMinimum:                  string ;
val XmCPattern:                      string ;
val XmCPendingDelete:                string ;
val XmCPixmap:                       string ;
val XmCPopupEnabled:                 string ;
val XmCPosition:                     string ;
val XmCPostFromButton:               string ;
val XmCProcessingDirection:          string ;
val XmCPromptString:                 string ;
val XmCPushButtonEnabled:            string ;
val XmCRadioAlwaysOne:               string ;
val XmCRadioBehavior:                string ;
val XmCRecomputeSize:                string ;
val XmCRepeatDelay:                  string ;
val XmCResizeHeight:                 string ;
val XmCResizePolicy:                 string ;
val XmCResizeWidth:                  string ;
val XmCRowColumnType:                string ;
val XmCRows:                         string ;
val XmCRubberPositioning:            string ;
val XmCSashHeight:                   string ;
val XmCSashIndent:                   string ;
val XmCSashWidth:                    string ;
val XmCSaveUnder:                    string ;
val XmCScaleHeight:                  string ;
val XmCScaleMultiple:                string ;
val XmCScaleWidth:                   string ;
val XmCScroll:                       string ;
val XmCScrollBarDisplayPolicy:       string ;
val XmCScrollBarPlacement:           string ;
val XmCScrollSide:                   string ;
val XmCScrolledWindowMarginHeight:   string ;
val XmCScrolledWindowMarginWidth:    string ;
val XmCScrollingPolicy:              string ;
val XmCSelectColor:                  string ;
val XmCSelectInsensitivePixmap:      string ;
val XmCSelectPixmap:                 string ;
val XmCSelectThreshold:              string ;
val XmCSelectedItemCount:            string ;
val XmCSelectedItems:                string ;
val XmCSelectionArray:               string ;
val XmCSelectionArrayCount:          string ;
val XmCSelectionLabelString:         string ;
val XmCSelectionPolicy:              string ;
val XmCSensitive:                    string ;
val XmCSeparatorOn:                  string ;
val XmCSeparatorType:                string ;
val XmCSet:                          string ;
val XmCShadowThickness:              string ;
val XmCShadowType:                   string ;
val XmCShellUnitType:                string ;
val XmCShowArrows:                   string ;
val XmCShowAsDefault:                string ;
val XmCShowSeparator:                string ;
val XmCShowValue:                    string ;
val XmCSliderSize:                   string ;
val XmCSpacing:                      string ;
val XmCStringDirection:              string ;
val XmCTextFontList:                 string ;
val XmCTextPosition:                 string ;
val XmCTextString:                   string ;
val XmCTitle:                        string ;
val XmCTitleEncoding:                string ;
val XmCTitleString:                  string ;
val XmCTopItemPosition:              string ;
val XmCTopShadowColor:               string ;
val XmCTopShadowPixmap:              string ;
val XmCTransient:                    string ;
val XmCTransientFor:                 string ;
val XmCTranslations:                 string ;
val XmCTraversalOn:                  string ;
val XmCTroughColor:                  string ;
val XmCUnitType:                     string ;
val XmCUseAsyncGeometry:             string ;
val XmCValue:                        string ;
val XmCVerifyBell:                   string ;
val XmCVerticalScrollBar:            string ;
val XmCVisibleItemCount:             string ;
val XmCVisibleWhenOff:               string ;
val XmCVisual:                       string ;
val XmCVisualPolicy:                 string ;
val XmCWaitForWm:                    string ;
val XmCWidget:                       string ;
val XmCWidth:                        string ;
val XmCWidthInc:                     string ;
val XmCWinGravity:                   string ;
val XmCWindowGroup:                  string ;
val XmCWmTimeout:                    string ;
val XmCWordWrap:                     string ;
val XmCWorkWindow:                   string ;
val XmCX:                            string ;
val XmCY:                            string ;
end (* sig *) ;
