%define version 0.15
%define myrelease 1

%define srel /etc/SuSE-release
%define rrel /etc/redhat-release
%define mrel /etc/mandrake-release
%define isSUSE %(test -f %{srel} && echo 1 || echo 0)
%define isRH %(test -f %{rrel} && echo 2 || echo 0)
%define isMDK %(test -f %{mrel} && echo 1 || echo 0)
%if "%{isMDK}" > "0"
%define isRH 1
%endif
#
# Running the above, results in:
#
# RedHat:   isSUSE=0 isRH=2 isMDK=0
# Mandrake: isSUSE=0 isRH=1 isMDK=1
# SuSE:     isSUSE=1 isRH=0 isMDK=0
#

%define _qtdir ""
%if "%{isSUSE}" > "0"
%define REL %(grep VERSION %{srel} | sed -e 's/VERSION = //')
%if "%{REL}" >= "8.0"
# Bug in SuSE8.0's rpm setup: _initrddir has wrong value
%define _initrddir %{_sysconfdir}/init.d
%define _kdedir /opt/kde3
%else
%define _initrddir %{_sysconfdir}/init.d
%define _kdedir /opt/kde2
%endif
%define distro SuSE%{REL}
%endif
%if "%{isRH}" > "1"
%define REL %(rpm -qf --queryformat '%%{version}' %{rrel})
%define distro RH%{REL}
%define _kdedir /usr
# Old RH7.2 has QT in qt-2.x.x which is not autodetected in configure
%define _qtdir %(test -n "$QTDIR" && echo \"--with-qt-dir=$QTDIR\" || :)
%endif
%if "%{isMDK}" > "0"
%define REL %(rpm -qf --queryformat '%%{version}' %{mrel})
%define distro mdk%{REL}
%define _kdedir /usr
%endif

%define _kdebindir %{_kdedir}/bin
%define _kdelibdir %{_kdedir}/lib
%define _kdedatadir %{_kdedir}/share
%define realrelease %{myrelease}%{distro}

#
# Conditionals
#
%{?_without_distro: %define realrelease %{myrelease}}
%{?_with_debug: %define __spec_install_post /usr/lib/rpm/brp-compress}
%{?_with_debug: %define _with_debug --enable-debug}
%{?_with_debug: %define optflags -g}
%{!?_with_debug: %define _with_debug --disable-debug}

Summary: Connectivity for psion series 5.
Name: plptools
Version: %{version}
Release: %{realrelease}
Vendor: The plptools project
Packager: Fritz Elfert <fritz.elfert@to.com>
URL: http://plptools.sourceforge.net/
Source0: http://download.sourceforge.net/plptools/plptools-%{version}.tar.gz
Copyright: GPL
Group: Networking/Utilities
Buildrequires: readline-devel newt-devel kdelibs-devel >= 2.1
%if "%{isSUSE}" > "0"
%if "%{REL}" >= "8.0"
Requires: aaa_base >= 2002.3.27-0
%else
Requires: aaa_base >= 2001.10.19-1
%endif
%endif
%if "%{isRH}" > "0"
Requires: chkconfig >= 0.9
%endif
BuildRoot: %{_tmppath}/plputils-buildroot

%package devel
Summary: Static library and includes for psion series 5 communication.
Group: Development/Libraries
Requires: %{name} = %{version}

%package kde
Summary: Psion support for KDE.
Group: User Interface/Desktops
Requires: %{name} = %{version}

%description
This package contains the programs (client and server), necessary to
communicate with a Psion palmtop. The psion's file-system will
be automatically mounted under /mnt/psion at the time it is
connected to your computer. If the psion is shut down or
disconnected, the contents of /mnt/psion will automatically
disappear. Other programs included are:
 - plpftp, a program which allows you to transfer files in a ftp-like
   manner, view and modifiy processes on your psion.
 - plpbackup, a backup/restore utility.
 - plpprintd, a daemon for enabling printing from a Psion Series 5 via any
   accessible printer.
 - sisinstall, an installer for Psion's SIS software package format.

%description devel
This package contains the static library and include files for building
programs which can communicate with a Psion palmtop.

%description kde
This package provides support for a new protocol prefix "psion:/" for
KDE. Any KDE application which uses KDE-conforming URLs, can access
files on the Psion. Furthermore, a plugin for Konqueror's file-properties
dialog provides access to Psions proprietary file attributes and information
about the Psion's drives as well as generic machine information.

%description -l de
Dieses Packet enthlt Programme zur Kommunikation mit einem Psion Palmtop.
Das Dateisystem des Psion wird beim Anschlieen automatisch unter
/mnt/psion eingehngt. Wird der Psion ausgeschaltet oder das Kabel
gezogen, so verschwindet der Inhalt dieses Verzeichnisses automatisch
und erscheint erneuten Anschlieen wieder. Weiterhin sind enthalten:
 - plpftp, ein Programm welches eine FTP-hnliche Oberflche fr Dateitransfer
   bietet und Prozesse auf dem Psion stoppen und starten kann.
 - plpbackup, ein Backup/Restore Utility fr die Kommandozeile.
 - plpprintd, ein Daemon welcher Ausdrucken von einem Psion Serie 5 ber
   beliebige vefgbare Drucker ermglicht
 - sisinstall, ein Installationsprogramm fr das Psion-eigene SIS
   packetformat.

%description -l de devel
Dieses Packet enthlt die statische Bibliothek und include-Dateien
zur Programm-Entwicklung von Kommunikations-software fr den Psion.

%description -l de kde
Dieses Packet stellt Untersttzung fr eine neues Protokoll-Prfix "psion:/"
fr KDE bereit. Jede KDE Anwendung, die KDE-konforme URLs benutzt, kann
damit auf die Dateien eines Psion zugreifen. Weiterhin, liefert ein Plugin
fr Konqueror's Datei-Eigenschaften-Dialog Informationen ber proprietre
Psion-Dateiattribute und stellt Informationen zum Gert sowie seiner
Laufwerke zur Verfgung.

%package -n kpsion
Summary: Psion utility for KDE.
Group: User Interface/Desktops
Requires: %{name} = %{version}

%description -n kpsion
This package contains a KDE utility program for backup, restore and formatting
Psion drives.

%description -l de -n kpsion
Dieses Packet enthlt ein KDE Werkzeug zum Backup, Restore und Formatieren
von Psion Laufwerken.

%package -n klipsi
Summary: Psion remote clipboard utility for KDE.
Group: User Interface/Desktops
Requires: %{name} = %{version}

%description -n klipsi
This package contains a KDE utility for using the Psion's remote clipboard
function.

%description -l de -n klipsi
Dieses Packet enthlt ein KDE Werkzeug zum Transfer der Zwischenablage
zwischen Psion und Rechner.

%changelog
* Fri May 25 2001 Fritz Elfert <fritz.elfert@to.com>
- Added klipsi subpackage

* Thu May 17 2001 Fritz Elfert <fritz.elfert@to.com>
- Official release of version 0.8

* Thu Mar  1 2001 Fritz Elfert <fritz.elfert@to.com>
- Added KDE sub-packages

* Sat Jan 20 2001 Fritz Elfert <fritz.elfert@to.com>
- Updated to latest version
- Using RPM 4 (RH 7.0)

* Mon Jan 17 2000 Fritz Elfert <fritz.elfert@to.com>
- New version 0.5 with lots of bugfixes and additions.

* Sat Aug  7 1999 Fritz Elfert <fritz.elfert@to.com>
- fixed violation of const parameters in rfsv32.cc.
- corrected BLOCKSIZE in mp.h to fix behaviour of "du" program.

%prep
%setup -q
%if "%{isSUSE}" > "0"
# SuSE's depencies are pretty broken. Example: For the KDE stuff,
# RPM's automatic find-requires generates a depency to libGLcore
# if the build-system has Nvidia drivers installed. Our KDE stuff
# definitively does NOT depend on it!
# Therefore, we filter some unnecessary stuff out:
cat<<EOF>find-requires
#!/bin/sh
%{__find_requires} "$@" |egrep -v 'libGL|freetype|libfam'
EOF
chmod a+x find-requires
%define __find_requires %{_builddir}/%{buildsubdir}/find-requires
%endif
%if "%{isMDK}" > "0"
# Mandrake's RPM generates similar odd depencies.
cat<<EOF>find-requires
#!/bin/sh
%{__find_requires} "$@" |egrep -v 'libGL|freetype'
EOF
chmod a+x find-requires
%define __find_requires %{_builddir}/%{buildsubdir}/find-requires
%endif

%build
%if "%{isSUSE}" > "0"
# SuSE's libtools are breaking everything
%define __libtoolize true
%if "%{REL}" >= "8.0"
%configure --enable-kde --with-initdir=%{_initrddir} --with-kdedir=/opt/kde3 %{_with_debug}
%else
%configure --enable-kde --with-initdir=%{_initrddir} --with-kdedir=/opt/kde2 %{_with_debug}
%endif
%endif
%if "%{isMDK}" > "0"
# Mandrake's libtool builds, but refuses to install kde modules into
# a directory not ending with /usr/lib - kinda strange
#
%define __libtoolize true
%endif
%if "%{isRH}" > "0"
QD=%{_qtdir}
%configure --enable-kde $QD --with-initdir=%{_initrddir} %{_with_debug}
%endif
make

%install
mkdir -p $RPM_BUILD_ROOT/%{_prefix} $RPM_BUILD_ROOT%{_initrddir} \
# rpm's makeinstall doesn't work here!
make DESTDIR=$RPM_BUILD_ROOT install
install -m 644 conf/kiodoc-update.pl \
	$RPM_BUILD_ROOT%{_datadir}/%{name}/kiodoc-update.pl
%if "%{isSUSE}" > "0"
%if "%{REL}" >= "8.0"
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
cat>$RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/psion<<EOF
START_NCPD=yes
NCPD_ARGS=
START_PLPNFSD=no
PLPNFSD_ARGS=
START_PLPPRINTD=yes
PLPPRINTD_ARGS=
EOF
install -m755 etc/psion.SuSE8 $RPM_BUILD_ROOT%{_initrddir}/psion
%else
install -m755 etc/psion.SuSE $RPM_BUILD_ROOT%{_initrddir}/psion
%endif
%endif
%if "%{isRH}" > "0"
install -m755 etc/psion $RPM_BUILD_ROOT%{_initrddir}/psion
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
cat>$RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/psion<<EOF
START_NCPD=yes
NCPD_ARGS=
START_PLPNFSD=no
PLPNFSD_ARGS=
START_PLPPRINTD=yes
PLPPRINTD_ARGS=
EOF
%endif
%if "%{isMDK}" > "0"
# Mandrake has a menu configurator
mkdir -p $RPM_BUILD_ROOT%{_libdir}/menu
echo '?package(kpsion): needs="kde" kde_filename="kpsion" section="Office/PDA" title="KPsion" icon="psion_desktop.png" command="kpsion" kde_opt="\\nEncoding=UTF-8\\nGenericName=My Psion PDA\\nDocPath=kpsion/index.html\\nTerminal=0\\nX-KDE-StartupNotify=true"' > $RPM_BUILD_ROOT%{_libdir}/menu/kpsion
echo '?package(klipsi): needs="kde" kde_filename="klipsi" section="Office/PDA" title="Klipsi" icon="klipsi.png" command="klipsi" kde_opt="\\nEncoding=UTF-8\\nGenericName=Psion Clipboard Utility\\nDocPath=klipsi/index.html\\nTerminal=0\\nX-KDE-StartupNotify=true"' > $RPM_BUILD_ROOT%{_libdir}/menu/klipsi
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post
ldconfig
test ! -d /mnt/psion && mkdir -p /mnt/psion
%if "%{isRH}" > "0"
/sbin/chkconfig --add psion
%endif
%if "%{isSUSE}" > "0"
%if "%{REL}" >= "8.0"
/sbin/chkconfig --add psion
%else
(
	grep -v START_PSION /etc/rc.config | \
		grep -v START_NCPD | grep -v NCPD_ARGS | \
		grep -v START_PLPNFSD | grep -v PLPNFSD_ARGS | \
		grep -v START_PLPPRINTD | grep -v PLPPRINTD_ARGS
	cat<<-EOF
	# Set START_PSION to yes to start Psion support
	START_PSION=yes
	# Set START_NCPD to yes to start ncpd
	START_NCPD=yes
	# Specify parameters for ncpd in NCPD_ARGS (if any)
	NCPD_ARGS=
	# Set START_PLPNFSD to yes to start plpnfsd
	START_PLPNFSD=no
	# Specify parameters for plpnfsd in PLPNFSD_ARGS (if any)
	PLPNFSD_ARGS=
	# Set START_PLPPRINTD to yes to start plpprintd
	START_PLPPRINTD=yes
	# Specify parameters for plpprintd in PLPPRINTD_ARGS (if any)
	PLPPRINTD_ARGS=
	EOF
) > /etc/rc.config.$$
cp /etc/rc.config /etc/rc.config.old && mv /etc/rc.config.$$ /etc/rc.config
/sbin/insserv -d psion
%endif
%endif

%if "%{isRH}" > "1"
%triggerin kde -- kdebase, kde-i18n-German
perl %{_datadir}/%{name}/kiodoc-update.pl -a psion
%endif

%if "%{isMDK}" > "0"
%triggerin kde -- kdebase, kde-i18n-de
perl %{_datadir}/%{name}/kiodoc-update.pl -a psion
%endif

%if "%{isSUSE}" > "0"
%if "%{REL}" >= "8.0"
%triggerin kde -- kdebase3, kde-i18n-de
export PATH=%{_kdebindir}:$PATH
perl %{_datadir}/%{name}/kiodoc-update.pl -a psion
%else
%triggerin kde -- kdebase, kde-i18n-de
export PATH=%{_kdebindir}:$PATH
perl %{_datadir}/%{name}/kiodoc-update.pl -a psion
%endif
%endif

%if "%{isMDK}" > "0"
%post -n kpsion
update-menus

%post -n klipsi
update-menus
%endif

%post kde
%if "%{isSUSE}" > "0"
export PATH=%{_kdebindir}:$PATH
%endif
KONQRC=`%{_kdebindir}/kde-config --expandvars --install config`/konquerorrc
if test -f $KONQRC && grep -q '\[Notification Messages\]' $KONQRC ; then
	cp $KONQRC $KONQRC.$$
	cat $KONQRC.$$ | grep -v "askSaveinode/x-psion-drive=No" | sed \
		-e '/\[Notification Messages\]/a\' \
		-e 'askSaveinode/x-psion-drive=No' > $KONQRC && \
	rm -f $KONQRC.$$
else
cat>>$KONQRC<<EOF

[Notification Messages]
askSaveinode/x-psion-drive=No
EOF
fi

%preun
if [ "$1" = 0 ]
then
	%{_initrddir}/psion stop >/dev/null 2>&1
%if "%{isSUSE}" > "0"
%if "%{REL}" >= "8.0"
	/sbin/chkconfig --del psion
%else
	/sbin/insserv -r -d psion
%endif
%endif
%if "%{isRH}" > "0"
	/sbin/chkconfig --del psion
%endif
fi

%preun kde
%if "%{isSUSE}" > "0"
export PATH=%{_kdebindir}:$PATH
%endif
if [ "$1" = 0 ]
then
	/usr/bin/perl %{_datadir}/%{name}/kiodoc-update.pl -r psion
	KONQRC=`kde-config --expandvars --install config`/konquerorrc
	if test -f $KONQRC ; then
		cp $KONQRC $KONQRC.$$
		grep -v 'askSaveinode/x-psion-drive=' $KONQRC.$$ > $KONQRC && \
		rm -f $KONQRC.$$
	fi
fi

%files
%doc COPYING INSTALL CHANGES ChangeLog README TODO etc/*magic patches
%{_bindir}/plpftp
%{_bindir}/plpbackup
%{_bindir}/sisinstall
%{_sbindir}/*
%{_mandir}/*/*
%{_libdir}/libplp.so.*
%{_libdir}/libplp.la
%{_datadir}/locale/*/LC_MESSAGES/plptools.mo
%{_datadir}/%{name}/*
%{_initrddir}/psion
%if "%{isSUSE}" > "0"
%if "%{REL}" >= "8.0"
%config %{_sysconfdir}/sysconfig/psion
%endif
%endif
%if "%{isRH}" > "0"
%config %{_sysconfdir}/sysconfig/psion
%endif

%files devel
%doc doc/api etc/*.spec
%{_libdir}/libplp.a
%{_libdir}/libplp.so
%{_includedir}/%{name}/*

%files kde
%{_kdelibdir}/kde*/kio_plp.so*
%{_kdelibdir}/kde*/kio_plp.la
%{_kdelibdir}/kde*/libplpprops.so*
%{_kdelibdir}/kde*/libplpprops.la
%{_kdedatadir}/services/*
%{_kdedatadir}/icons/*/*/mimetypes/*
%{_kdedatadir}/icons/*/*/devices/*
%{_kdedatadir}/icons/*/*/apps/psion*
%{_kdedatadir}/locale/*/LC_MESSAGES/libplpprops.mo
%{_kdedatadir}/mimelnk/*/*
%{_kdedatadir}/doc/HTML/*/kioslave/*
%{_datadir}/%{name}/kiodoc-update.pl

%files -n kpsion
%{_kdebindir}/kpsion
%{_kdelibdir}/libkpsion.so*
%{_kdelibdir}/libkpsion.la
%if "%{isMDK}" > "0"
%{_libdir}/menu/kpsion
%endif
%{_kdedatadir}/applnk/*/kpsion*
%{_kdedatadir}/apps/kpsion/*
%{_kdedatadir}/apps/konqueror/*
%{_kdedatadir}/icons/*/*/apps/kpsion*
%{_kdedatadir}/icons/*/*/actions/psion*
%{_kdedatadir}/locale/*/LC_MESSAGES/kpsion.mo
%{_kdedatadir}/doc/HTML/*/kpsion

%files -n klipsi
%{_kdebindir}/klipsi
%{_kdelibdir}/klipsi.so*
%{_kdelibdir}/klipsi.la
%if "%{isMDK}" > "0"
%{_libdir}/menu/klipsi
%endif
%{_kdedatadir}/applnk/*/klipsi*
%{_kdedatadir}/apps/klipsi/*
%{_kdedatadir}/icons/*/*/apps/klipsi*
%{_kdedatadir}/icons/*/*/actions/klipsi*
%{_kdedatadir}/locale/*/LC_MESSAGES/klipsi.mo
