//---------------------------------------------------------------------------//
// $Id: PLStreamc.java,v 1.3 2004/01/17 16:41:37 rlaboiss Exp $
//
// Copyright (C) 2004  Alan W. Irwin
//
// This file is part of PLplot.
//
// PLplot is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Library Public License as published
// by the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// PLplot is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with PLplot; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// This file implements the core Java side of the Java->PLplot interface, by
// providing a Java class PLStreamc, which is intended to mirror the C
// PLStream of PLplot.  However, we go further here in Java than we were able
// to do in C, by actually making the PLplot API entry points methods of this
// stream class.  Thus, to plot to a stream in Java, you just instantiate the
// stream, and invoke PLplot API services upon it.  This is basically what we
// have tried to do in the bindings to other object oriented environments,
// such as C++ and the Tcl/Tk and Python/Tk widget contexts.  A stream
// represents sort of a "drawable" abstraction, and the PLplot API gets the
// drawing done on the identified stream.  In C you have to swtich the stream
// explicitly with the plsstrm function, but in Java you just invoke the API
// function on the approrpiate stream object.
//---------------------------------------------------------------------------//

package plplot.core;

public class PLStreamc {

// Methods needed for the implementation of PLStreamc, but not suitable for
// the public interface.
//    native int mkstrm();

// Static code block to get the PLplot java wrapper dynamic library loaded in.
   static {
      try {
	 System.load( plplot.core.config.libname );
      } catch (UnsatisfiedLinkError e) {
	 System.err.println("Native code library failed to load. See the chapter on Dynamic Linking Problems in the SWIG Java documentation for help.\n" + e);
	 System.exit(1);
      }
   }

// Class data.
    int stream_id;

// Now comes stuff we need done in Java.
    public PLStreamc()
    {
//        stream_id = mkstrm();
//        stream_id = plmkstrm();
    }

//    public int get_stream_id() { return stream_id; }
}

//---------------------------------------------------------------------------//
//                              End of PLStreamc.java
//---------------------------------------------------------------------------//

