/*
 * Common definitions for remote server for GDB.
 * Copyright (C) 1993 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __BIOS_H
#define __BIOS_H

#include <setjmp.h>
#include "plex86.h"
#include "user.h"
#include "plugin.h"
#include "elf.h"

#define VGA_BIOS_EIP  0xf0000

int    bin_load (char *guest_file_name, Bit32u address);
Bit32u image_load (char *path, Bit32u paddr);
void bin_dump (char *dump_file_name);
void bin_context (unsigned);
unsigned linux_hack(void);
unsigned load_linux_setup_params( Bit32u initrd_start, Bit32u initrd_size );

extern char vga_bios_start[];
extern char vga_bios_end[];

#endif
