/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  segment-mon.c:  access memory using virtual (seg:offset) ptr
 *                
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"


// xxx Could add code for REP string ops





  void
copyGuestDescToMon(vm_t *vm, unsigned sreg)
{
// xxx What checks prevent CS: for writes?
// xxx CS writable in RM


// xxx Could optimize reload of seg if same desc as before
// xxx Maybe we should check valid/p bits.
    /* If seg is CS, convert to data descriptor. */

    {
    /* This stuff needs to be done with interrupts off, otherwise
     * interrupts will cause monitor->host->monitor switches, will
     * reload a partially initialized descriptor!
     */
    asm volatile ( "cli\n\t" );
    vm->guest.addr.gdt[4+sreg] = vm->guest_cpu.desc_cache[sreg].desc;
    vm->guest.addr.gdt[4+sreg].dpl = 3;
    if (sreg==SRegCS) {
      /* When the guest CS descriptor cache is loaded, load the FS
       * descriptor with the virtualized descriptor.
       */
      vm->guest.addr.gdt[4+sreg].type = D_DATA | D_WRITE | D_ACCESSED;
      asm volatile ("movl %0, %%fs \n\t"
                    :
                    : "r" (Selector(4+sreg,0,RPL3))
                   );
      }
    else {
      vm->guest.addr.gdt[4+sreg].type =
          vm->guest_cpu.desc_cache[sreg].desc.type;
      }
    asm volatile ( "sti\n\t" );
    }
}


/* NOTE: I make use of the fact that GCC caller-saves certain registers,
 * so we are free to clobber them here.  This eliminates extra push/pop
 * instructions.
 */


/* Fetch routines.  Stack:
 *   offset32
 *   [return address]
 */

asm (
  ".globl __fetchCheckNative      \n\t"
  "__fetchCheckNative:            \n\t"
  "movl  4(%esp), %eax            \n\t" /* Guest offset. */
  ".globl __fetchCheckAttempt     \n\t"
  "__fetchCheckAttempt:           \n\t"
  "fs; movb (%eax), %al           \n\t" /* Read byte using seg:offset. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );


/* Read routines.  Stack:
 *   data pointer
 *   offset32
 *   selector
 *   [return address]
 */

asm (
  ".globl __readByteNative        \n\t"
  "__readByteNative:              \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Ptr to store result. */
  ".globl __readByteAttempt       \n\t"
  "__readByteAttempt:             \n\t"
  "gs; movb (%eax), %al           \n\t" /* Read byte using seg:offset. */
  "movb  %al, (%edx)              \n\t" /* Store byte using ptr. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"

  ".globl __readError             \n\t"
  "__readError:                   \n\t"
  "movl  $0, %eax                 \n\t" /* Return Error. */
  "ret                            \n\t"
  );

asm (
  ".globl __readWordNative        \n\t"
  "__readWordNative:              \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Ptr to store result. */
  ".globl __readWordAttempt       \n\t"
  "__readWordAttempt:             \n\t"
  "gs; movw (%eax), %ax           \n\t" /* Read word using seg:offset. */
  "movw  %ax, (%edx)              \n\t" /* Store word using ptr. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );

asm (
  ".globl __readDWordNative       \n\t"
  "__readDWordNative:             \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Ptr to store result. */
  ".globl __readDWordAttempt      \n\t"
  "__readDWordAttempt:            \n\t"
  "gs; movl (%eax), %eax          \n\t" /* Read dword using seg:offset. */
  "movl  %eax, (%edx)             \n\t" /* Store dword using ptr. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );

/* Read-Modify-Write versions of native read functions. */
asm (
  ".globl __readRMWByteNative     \n\t"
  "__readRMWByteNative:           \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Ptr to store result. */
  ".globl __readRMWByteAttempt    \n\t"
  "__readRMWByteAttempt:          \n\t"
  "gs; orb  $0, (%eax)            \n\t" /* Test writability of data area. */
  "gs; movb (%eax), %al           \n\t" /* Read byte using seg:offset. */
  "movb  %al, (%edx)              \n\t" /* Store byte using ptr. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );

asm (
  ".globl __readRMWWordNative     \n\t"
  "__readRMWWordNative:           \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Ptr to store result. */
  ".globl __readRMWWordAttempt    \n\t"
  "__readRMWWordAttempt:          \n\t"
  "gs; orw  $0, (%eax)            \n\t" /* Test writability of data area. */
  "gs; movw (%eax), %ax           \n\t" /* Read word using seg:offset. */
  "movw  %ax, (%edx)              \n\t" /* Store word using ptr. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );

asm (
  ".globl __readRMWDWordNative    \n\t"
  "__readRMWDWordNative:          \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Ptr to store result. */
  ".globl __readRMWDWordAttempt   \n\t"
  "__readRMWDWordAttempt:         \n\t"
  "gs; orl  $0, (%eax)            \n\t" /* Test writability of data area. */
  "gs; movl (%eax), %eax          \n\t" /* Read dword using seg:offset. */
  "movl  %eax, (%edx)             \n\t" /* Store dword using ptr. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );


/* Write routines. */
asm (
  ".globl __writeByteNative       \n\t"
  "__writeByteNative:             \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Data ptr. */
  "movb  (%edx), %dl              \n\t" /* Get byte using data ptr. */
  ".globl __writeByteAttempt      \n\t"
  "__writeByteAttempt:            \n\t"
  "gs; movb %dl, (%eax)           \n\t" /* Write byte using seg:offset. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"

  ".globl __writeError            \n\t"
  "__writeError:                  \n\t"
  "movl  $0, %eax                 \n\t" /* Return Error. */
  "ret                            \n\t"
  );

asm (
  ".globl __writeWordNative       \n\t"
  "__writeWordNative:             \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Data ptr. */
  "movw  (%edx), %dx              \n\t" /* Get word using data ptr. */
  ".globl __writeWordAttempt      \n\t"
  "__writeWordAttempt:            \n\t"
  "gs; movw %dx, (%eax)           \n\t" /* Write word using seg:offset. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );

asm (
  ".globl __writeDWordNative      \n\t"
  "__writeDWordNative:            \n\t"
  "movl  4(%esp), %gs             \n\t"
  "movl  8(%esp), %eax            \n\t" /* Guest offset. */
  "movl  12(%esp), %edx           \n\t" /* Data ptr. */
  "movl  (%edx), %edx             \n\t" /* Get dword using data ptr. */
  ".globl __writeDWordAttempt     \n\t"
  "__writeDWordAttempt:           \n\t"
  "gs; movl %edx, (%eax)          \n\t" /* Write dword using seg:offset. */
  "movl  $1, %eax                 \n\t" /* Return OK. */
  "ret                            \n\t"
  );
