/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  logical8.c:  8-bit logical instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"


  void
AND_GbEb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "andb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  WriteReg8(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}

  void
OR_EbIb(vm_t *vm)
{
  Bit8u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Ib;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "orb  %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_ALIb(vm_t *vm)
{
  Bit8u  op2, op1;
  Bit32u eflags;
 
  op1 = G_AL(vm);
  op2 = vm->i.Ib;
 
  asm volatile (
    "xorb  %3, %1 \n\t"
    "pushfl       \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  G_AL(vm) = op1;
  SetOSZAPC(vm, eflags);
}

  void
XOR_EbIb(vm_t *vm)
{
  Bit8u  op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Ib;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "xorb  %3, %1 \n\t"
    "pushfl       \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
NOT_Eb(vm_t *vm)
{
  Bit8u op1;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  op1 = ~op1;
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
}

  void
XOR_EbGb(vm_t *vm)
{
  Bit8u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "xorb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_EbIb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op2 = vm->i.Ib;
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "andb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_EbGb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op2 = ReadReg8(vm, vm->i.nnn);

  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "andb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
AND_ALIb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op1 = G_AL(vm);
  op2 = vm->i.Ib;
 
  asm volatile (
    "andb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  G_AL(vm) = op1;
 
  SetOSZAPC(vm, eflags);
}

  void
OR_ALIb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op1 = G_AL(vm);
  op2 = vm->i.Ib;
 
  asm volatile (
    "orb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  G_AL(vm) = op1;
 
  SetOSZAPC(vm, eflags);
}

  void
OR_GbEb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "orb %3, %1  \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  WriteReg8(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}

  void
XOR_GbEb(vm_t *vm)
{
  Bit8u op1, op2;
  Bit32u eflags;
 
  op1 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  asm volatile (
    "xorb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  WriteReg8(vm, vm->i.nnn, op1);
 
  SetOSZAPC(vm, eflags);
}

  void
OR_EbGb(vm_t *vm)
{
  Bit8u op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_RMW_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "orb %3, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags), "=q" (op1)
    : "1" (op1), "mq" (op2)
    : "memory", "cc"
    );

 
  if (vm->i.mod == 0xc0) {
    WriteReg8(vm, vm->i.rm, op1);
    }
  else {
    write_RMW_virtual_byte(vm, &op1);
    }
 
  SetOSZAPC(vm, eflags);
}

  void
TEST_EbIb(vm_t *vm)
{
  Bit8u op2, op1;
  Bit32u eflags;
 
  op2 = vm->i.Ib;
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "testb %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "q" (op1), "mq" (op2)
    : "memory", "cc"
    );

  SetOSZAPC(vm, eflags);
}

  void
TEST_EbGb(vm_t *vm)
{
  Bit8u  op2, op1;
  Bit32u eflags;
 
  op2 = ReadReg8(vm, vm->i.nnn);
 
  if (vm->i.mod == 0xc0) {
    op1 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op1);
    }
 
  asm volatile (
    "testb %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "q" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}

  void
TEST_ALIb(vm_t *vm)
{
  Bit8u  op2, op1;
  Bit32u eflags;
 
  op1 = G_AL(vm);
  op2 = vm->i.Ib;
 
  asm volatile (
    "testb %2, %1 \n\t"
    "pushfl      \n\t"
    "popl   %0"
    : "=g" (eflags)
    : "q" (op1), "mq" (op2)
    : "memory", "cc"
    );
 
  SetOSZAPC(vm, eflags);
}
