/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  vopcodemap-host.c: Virtualization opcode maps.  These are used
 *    to efficiently determine which instructions must be virtualized
 *    or executed natively.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_HOST_SPACE
#include "monitor.h"



/* For clarity, label certain prefix bytes even though their entry
 * is not used in the main part of the matrix.
 */
#define Gx 0 /* Group 0..A. */
#define FP 0 /* Floating Pointer ESC prefix. */
#define Pr 0 /* Prefix byte. */


/* Strongest opcode virtualization map.  Other maps can be formed
 * by starting with this map, and reducing the number of instructions
 * which are virtualized.
 */

vOpcodeMap_t vOpcodeMapStrongest = {

{
/******************************* 1-byte opcodes ******************************/
/*             0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F */
/*****************************************************************************/
/* 00..0F */  RN, RN, RN, RN, RN, RN,  0,  0, RN, RN, RN, RN, RN, RN,  0,  0,
/* 10..1F */  RN, RN, RN, RN, RN, RN,  0,  0, RN, RN, RN, RN, RN, RN,  0,  0,
/* 20..2F */  RN, RN, RN, RN, RN, RN, Pr, RN, RN, RN, RN, RN, RN, RN, Pr, RN,
/* 30..3F */  RN, RN, RN, RN, RN, RN, Pr, RN, RN, RN, RN, RN, RN, RN, Pr, RN,
/* 40..4F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 50..5F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* 60..6F */  RN, RN,  0,  0, Pr, Pr, Pr, Pr, RN, RN, RN, RN,  0,  0,  0,  0,
/* 70..7F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 80..8F */  Gx, Gx, Gx, Gx, RN, RN, RN, RN, RN, RN, RN, RN,  0, RN,  0, RN,
/* 90..9F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,  0,  0,  0,  0, RN, RN,
/* A0..AF */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* B0..BF */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* C0..CF */  Gx, Gx,  0,  0,  0,  0, RN, RN, RN, RN,  0,  0,  0,  0,  0,  0,
/* D0..DF */  Gx, Gx, Gx, Gx, RN, RN, RN, RN, FP, FP, FP, FP, FP, FP, FP, FP,
/* E0..EF */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* F0..FF */  Pr,  0, Pr, Pr,  0, RN, Gx, Gx, RN, RN,  0,  0, RN, RN, Gx, Gx,
/*****************************************************************************/

/******************************* 2-byte opcodes ******************************/
/*             0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F */
/*****************************************************************************/
/* 00..0F */  Gx, Gx,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 10..1F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 20..2F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 30..3F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 40..4F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 50..5F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 60..6F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70..7F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 80..8F */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
/* 90..9F */  RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN, RN,
/* A0..AF */   0,  0,  0, RN, RN, RN,  0,  0,  0,  0,  0, RN, RN, RN,  0, RN,
/* B0..BF */  RN, RN,  0, RN,  0,  0, RN, RN,  0,  0, Gx, RN, RN, RN, RN, RN,
/* C0..CF */  RN, RN,  0,  0,  0,  0,  0,  0, RN, RN, RN, RN, RN, RN, RN, RN,
/* D0..DF */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* E0..EF */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* F0..FF */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/*****************************************************************************/
},

{
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G1EbIb  */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G1Ew    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G1Ed    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G2Eb    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G2Ew    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G2Ed    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G3Eb    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G3Ew    */
      { RN, RN, RN, RN, RN, RN, RN, RN }, /* G3Ed    */
      { RN, RN, 0,  0,  0,  0,  0,  0  }, /* G4      */
      { RN, RN, 0,  0,  0,  0,  RN, 0  }, /* G5w     */
      { RN, RN, 0,  0,  0,  0,  RN, 0  }, /* G5d     */
      { 0,  0,  0,  0,  0,  0,  0,  0  }, /* G6      */
      { 0,  0,  0,  0,  0,  0,  0,  0  }, /* G7      */
      { 0,  0,  0,  0,  RN, RN, RN, RN }, /* G8EvIb  */
      { 0,  0,  0,  0,  0,  0,  0,  0  }, /* G9      */
}

};



/* Initialize the virtualized instruction opcode maps. */

  void
dtInitVOpcodeMaps(void)
{
  unsigned op;

// xxx Look at following opcodes:
// xxx   9B: WAIT
// xxx   CE: INTO (could translate this)
// xxx   Group 9/A opcodes.  (currently map only handles g0..7)

  if (cpuid_info.featureFlags.fields.cmov) {
    /* CMOV instructions can be run natively if they are available. */
    for (op=0x140; op<=0x14f; op++) {
      vOpcodeMapStrongest.standard[op] = RN;
      }
    }

  /* Short-displacement direct jump-on-conditions. */
  for (op=0x70; op<=0x7f; op++) {
    vOpcodeMapStrongest.standard[op] |= VOpcodeTranslate;
    }
  /* Long-displacement direct jump-on-conditions. */
  for (op=0x180; op<=0x18f; op++) {
    vOpcodeMapStrongest.standard[op] |= VOpcodeTranslate;
    }
  vOpcodeMapStrongest.standard[0xe2] |= VOpcodeTranslate; /* Loop_Jb */
  vOpcodeMapStrongest.standard[0xe3] |= VOpcodeTranslate; /* JCXZ_Jb */
  vOpcodeMapStrongest.standard[0xe9] |= VOpcodeTranslate; /* Jmp_Jv */
  vOpcodeMapStrongest.standard[0xeb] |= VOpcodeTranslate; /* Jmp_Jb */
}
