/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  dt-nexus.c: DT related features which are accessed from
 *    either space.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_NEXUS_SPACE
#include "monitor.h"






  void
dtInitialize(vm_t *vm)
{
  /* Zero L2M and G2T hash tables for good measure. */
  mon_memset(vm->addr->dtL2MHash, 0, sizeof(dtL2MHash_t));
  mon_memset(vm->addr->dtG2THash, 0, sizeof(dtG2THash_t));

  /* Now, init the hash tables. */
  dtInitHashTables(vm);

  /* Zero the page meta info table, and usage bitlist.  This stores
   * DT info about each associated guest code page.
   */
  mon_memset(vm->addr->dtPageMetaTable, 0,
             sizeof(dtPageMeta_t) * DTPageMetaTableN);
  mon_memset(vm->addr->dtPageMetaTableUsage, 0,
             sizeof(Bit8u) * ((DTPageMetaTableN+7) / 8));

  /* Initialize the tcode chunks, and usage bitlist. */
  mon_memset(vm->addr->tcodeChunk,      0, SizeOfTcodeBuffer);
  mon_memset(vm->addr->tcodeChunkUsage, 0,
             sizeof(Bit8u) * ((TCodeChunkN+7) / 8));
}

  void
dtInitHashTables(vm_t *vm)
{
  unsigned hashRow;

  /* L2M hash table:
   *
   * Mark the first pair in each hash row with a non-existant
   * meta index value.  This signifies that the entire row is empty
   * and available.
   * xxx For the L2M hash table, it may be more efficient
   * xxx to just mark all entries during context switches, rather than
   * xxx per-row dynamically, since it is farily small.
   */
  for (hashRow=0; hashRow<DT_L2MHashHeight; hashRow++) {
    (*(vm->addr->dtL2MHash))[hashRow][0].metai = MetaIndexNone;
    }

  dtInitG2THashTable(vm);
}

  void
dtInitG2THashTable(vm_t *vm)
{
  unsigned hashRow;

  /* G2T hash table:
   *
   * Mark the first pair in each hash row with a non-existant
   * tcode address value.  This signifies that the entire row is empty
   * and available.  The rest of the row will be marked dynamically when
   * the first new pair is stored.  The idea is to prevent unnecessary
   * writes to a fairly large construct for every context switch.
   */

  for (hashRow=0; hashRow<DT_G2THashHeight; hashRow++) {
    (*(vm->addr->dtG2THash))[hashRow][0].tOff = TcodeOffsetNone;
    }
  /* The G2T hash table is flushed every time there is an event which
   * change the guest context such that the cached values in it may not
   * be valid.  Generated tcode for direct branches has an ID check inline,
   * which is compared to a global ID.  This global ID needs to be incremented
   * during such conditions.
   */
  vm->addr->r3hData->hashID++;
}
