/*
 * entry.S:  Entry code for the NULL kernel
 *
 * (C) 1999 Ramon van Handel, The Alliance Operating System Team
 *
 * HISTORY
 * Date      Author      Rev    Notes
 * 09/01/99  ramon       1.0    First release
 * 14/07/99  ramon       1.1    Adapted for plex86 NULL kernel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
.text

/*
 * This is the entry point of the NULL kernel.  It is where the
 * bootloader jumps when it passes control to the kernel.  Our job
 * is to get the system into such a state that we can run C code
 * properly.  This code also contains the Multiboot header for the
 * loader.
 *
 * We do not bother with setting up paging or anything of the kind.
 * We set up our stack, and clear the flags.  We simply discard the
 * multiboot info structure (the only reason I'm putting a multiboot
 * header in in the first place is because I need to test it from
 * my bootloader :))
 *
 * NOTE that the standard multiboot assumptions are applicable here !
 * So we assume that interrupts are off, etc.
 */

#define STACK 1024                   /* The initial stack size         */

.type  _start,@function              /* The kernel entry point         */
.globl _start
_start:
    lgdtl (loadgdt)                  /* Load our own GDT               */
    movw $0x10,%dx                   /* Init data segment regs         */
    movw %dx,%ds                     /* with new data segment          */
    movw %dx,%es
    movw %dx,%fs
    movw %dx,%gs
    movw %dx,%ss                     /* ... and the stack seg, too     */
    movl $1f,%esp                    /* Set up the stack               */

    ljmp $0x08,$1f                   /* Skip the mulitboot header      */

.p2align 2                           /* The multiboot header:          */
    .long  0x1BADB002                /* Multiboot magic number         */
    .long  0x00000000                /* Multiboot flags                */
    .long  0-0x1BADB002              /* Multiboot checksum             */

.p2align 2                           /* The initial stack              */
    .fill  STACK                     /* Reserve the room               */

1:                                   /* The entry code starts here     */
    pushl $2                         /* Clear the flags                */
    popfl

    xorl %ebp,%ebp                   /* Clear the stack frame pointer  */

    call  kmain                      /* Call kmain()                   */

    /* This place should never be reached */
