/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  test-st.c: test/print some of the sparse table storage mechanisms.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */



#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <signal.h>
#include <stdlib.h>

#include "dt.h"


static unsigned rL1Count = 0, rL1Hit   = 0;
static unsigned rL2Count = 0, rL2Hit   = 0;
static unsigned tcodeCount = 0, tcodeHit   = 0;

void printSTStats(void);


#if TestSparseTables
  void
testSparseTables(void)
{
  Bit8u tcode[64];
  unsigned pOff, metaIndex=0, tcodeLen;

#if 1
  {
  double r, max_tcode_len;
  unsigned max_offset = 0;

  pOff = 0;
  srandom(1); /* Change random seed. */

  printf("\n");
  printf("Enter max tcode sequence length (random values are based on this) > ");
  scanf("%lf", &max_tcode_len);

  while (max_offset == 0) {
    printf("Populate from offset 0 to [..4095]? > ");
    scanf("%u", &max_offset);
    if (max_offset > 4095)
      max_offset = 0;
    }

  for (pOff=0; pOff<max_offset; ) {
    r = (((double)random()) / ((double) RAND_MAX)) * max_tcode_len;
    tcodeLen = (unsigned) r;
    if (tcodeLen==0)
      tcodeLen = 1;
    (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
    pOff += tcodeLen;
    }
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);
  }
#else

  printf("=============================================\n");
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  tcodeLen = 4;

  printf("=============================================\n");
  pOff = 288;
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  printf("=============================================\n");
  pOff++;
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  printf("=============================================\n");
  pOff++;
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  printf("=============================================\n");
  pOff++;
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  printf("=============================================\n");
  pOff++;
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  printf("=============================================\n");
  pOff++;
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);

  printf("=============================================\n");
  pOff = 288 + 256; /* increment L0 */
  (void) dtAddTcode(metaIndex, tcode, tcodeLen, pOff);
  printSTForwardL0(metaIndex);
  stTcodeStats(metaIndex, dtPageMetaTable[metaIndex].tcodeChunkHead);
#endif
}
#endif



  void
printSTForwardL0(unsigned metaIndex)
{
  unsigned l0;
  stForwardL1Frame_t   *l1Frame;

  printf("Forward:\n");
  for (l0=0; l0<STForwardL0N; l0++) {
    l1Frame = dtPageMetaTable[metaIndex].i2tL0[l0];
    if (l1Frame) {
      printf("L0[%x]:", l0);
      printf("--v\n");
      printSTForwardL1(l1Frame);
      }
    }
}

  void
printSTForwardL1(stForwardL1Frame_t *l1Frame)
{
  unsigned l1;
  stForwardL2Cluster_t *l2Cluster;

  for (l1=0; l1<STForwardL1N; l1++) {
    l2Cluster = (*l1Frame)[l1];
    if (l2Cluster) {
      printf("        L1[%x]:", l1);
      printf("--v\n");
      printSTForwardL2(l2Cluster);
      }
    }
}

  void
printSTForwardL2(stForwardL2Cluster_t *l2Cluster)
{
  unsigned clusterI, clusterCount=0;

  while (l2Cluster) {
    for (clusterI=0; clusterI<STForwardL2N; clusterI++) {
      if ( l2Cluster->element[clusterI].raw )
        printf("                C%x[%x]: addr4_0=%x, tcodeOff=%x\n",
               clusterCount, clusterI,
               l2Cluster->element[clusterI].fields.addr4_0,
               l2Cluster->element[clusterI].fields.tcodeOffset);
      }
    l2Cluster = l2Cluster->next;
    clusterCount++;
    }
}

  void
printSTReverseL1(unsigned metaIndex, tcodeChunk_t *head)
{
  unsigned l1;
  stReverseL2Cluster_t *l2Cluster;

  printf("Reverse:\n");
  while (head) {
    for (l1=0; l1<STReverseL1N; l1++) {
      l2Cluster = head->header.t2iL1[l1];
      if (l2Cluster) {
        printf("        L1[%x]:", l1);
        printf("--v\n");
        printSTReverseL2(l2Cluster);
        }
      }
    head = head->header.next;
    }
}

  void
printSTReverseL2(stReverseL2Cluster_t *l2Cluster)
{
  unsigned clusterI, clusterCount=0;

  while (l2Cluster) {
    for (clusterI=0; clusterI<STReverseL2N; clusterI++) {
      if ( l2Cluster->element[clusterI].raw ) {
        printf("                C%x[%x]: addr5_0=%x, tcodeLen=%u, pOff=%x\n",
               clusterCount, clusterI,
               l2Cluster->element[clusterI].fields.addr5_0,
               l2Cluster->element[clusterI].fields.tcodeLen,
               l2Cluster->element[clusterI].fields.pageOffset);
        }
      }
    l2Cluster = l2Cluster->next;
    clusterCount++;
    }
}

  void
stTcodeStats(unsigned metaIndex, tcodeChunk_t *head)
{
  unsigned l1;
  stReverseL2Cluster_t *l2Cluster;

  /* Reset counters */
  rL1Count = 0; rL1Hit   = 0;
  rL2Count = 0; rL2Hit   = 0;
  tcodeCount = 0; tcodeHit   = 0;

  while (head) {
    tcodeHit += (head->header.head - sizeof(head->header));
    tcodeCount += sizeof(tcodeChunk_t);
    for (l1=0; l1<STReverseL1N; l1++) {
      rL1Count++;
      l2Cluster = head->header.t2iL1[l1];
      if (l2Cluster) {
        rL1Hit++;
        stTcodeStatsL2(l2Cluster);
        }
      }
    head = head->header.next;
    }

  printf("rL1 density is %u/%u = %lf\n",
         rL1Hit,
         rL1Count,
         ((double) rL1Hit) / ((double) rL1Count));

  printf("rL2 density is %u/%u = %lf\n",
         rL2Hit,
         rL2Count,
         ((double) rL2Hit) / ((double) rL2Count));
  printf("tcode density is %u / %u(%u chunks) = %lf\n",
         tcodeHit,
         tcodeCount,
         tcodeCount/sizeof(tcodeChunk_t),
         ((double) tcodeHit) / ((double) tcodeCount));
}

  void
stTcodeStatsL2(stReverseL2Cluster_t *l2Cluster)
{
  unsigned clusterI, clusterCount=0;

  while (l2Cluster) {
    for (clusterI=0; clusterI<STReverseL2N; clusterI++) {
      rL2Count++;
      if ( l2Cluster->element[clusterI].raw ) {
        rL2Hit++;
        }
      }
    l2Cluster = l2Cluster->next;
    clusterCount++;
    }
}
