#include <stdio.h>

#include "dt.h"




  int
main(int argc, char *argv[])
{
  /* Get the current DS and copy it to the pretend handler SS. */
  asm volatile (
    "pushl %%ds \n\t"
    "popl  %0"
    : "=g" (handler_DS)
    :
    : "memory"
    );
  guest_SS = handler_DS;

  /* The handler ESP will point into our stack area. */
  handler_ESP = (unsigned) &handler_stack_area[HANDLER_STACK_SIZE];

  /* Pretend that DT engine has emitted code for current guest
   * CS:EIP instruction at location __seq0000.  Branch to code
   * sequence.  This would represent an IRET to ring3 running the
   * translated guest code, from the monitor.
   */
  printf("Calling translated code sequence at seq0000.\n");
  __seq0000();

  /* should not get here */
  return(0);
}



/* Some exit functions.  It's important that exits be done from the
 * 'guest' space (which is really the normal unix user space for this
 * test), so that the normal ESP is reloaded before we call any
 * unix calls like exit()!
 */


asm (
  ".text \n\t"
  ".globl __exit_ok   \n\t"
  "__exit_ok:         \n\t"
  "  call exit_ok \n\t"
  );

asm (
  ".text \n\t"
  ".globl __exit_bad  \n\t"
  "__exit_bad:        \n\t"
  "  call exit_bad\n\t"
  );

  void
exit_ok(void)
{
  fprintf(stderr, "Execution returns OK.\n");
  exit(0);
}

  void
exit_bad(void)
{
  fprintf(stderr, "Exit BAD\n");
  exit(-1);
}
