#!/usr/bin/perl

#
# This script generates Makefile.am files under directory data/images.
# -a option adds the above lines to generated Makefile.am file.
# -r does it recursively, intended for manual usage.
# -f forces overwriting Makefile.am file even it is not
#    auto-generated. Normally, script do not touch non-autogenerated
#    files.
# Please note that you should use options separately.
# generate_makefile.pl -far does NOT work instead you should use
# generate_makefile.pl -f -a -r
#
# See below for other adjustable options.
#
 
use strict;


my $imgfilepattern='\.(png|jpg)$';;
my $excludepattern='^(CVS|old|\\.)';;

my $debug=0;
my $recursive=0;
my $force=0;
my $autogenerate=0;
my $pwd;
my $arg;
my $progname;
my $numdirs;

$pwd=`pwd`; chop $pwd;
$progname = $0;

if ($pwd !~ /\/data\/images/) {
    die "This script should be called from a directory under data/images."; 
}



# cmdline parsing is a bit naive and buggy, but it works with some care.
# All cmdline options can be used as toggles. I do not think we need
# it.
 
while($arg = shift(@ARGV)) {
	if ($arg =~ /^-f/) { # rewrite the file even if it is not autogenerated
		$force = $force ? 0 : 1; 
	} elsif ($arg =~ /^-a/) { # enable for autogenrating `Makefile.am's
		$autogenerate = $autogenerate ? 0 : 1; 
	} elsif ($arg =~ /^-r/) { # enable recursion
		$recursive = $recursive ? 0 : 1;
	} elsif ($arg =~ /^-/) {
		die "unknow option $arg \n";
	} else {
		if ($arg =~ /^\//) {
			print "Skipping: $arg\n"; # full path doesn't work
			next;
		}
		$numdirs++;
		generate_makefile ($arg);
	}
}

# if no directory is given from cmdline, work on the current directory

if (! $numdirs) {
	generate_makefile(".");
}
exit (0);

sub generate_makefile {
	my $curr_dir; 
	my $relpath;
	my @imgfiles; 
	my @dirlist;
	my @dirlistX;
	my $firstline;
	my $file;
	my $test=0;
	my $dir;

	print("generate_makefile($_[0])\n") if ($debug);

	$curr_dir = $_[0];
	$test = $_[1]; 		# if supplied & == 1 dont genereate Makefile.am
	$relpath = $pwd . "/" . $curr_dir;

	$relpath =~ s,.*/data/(images/.*),$1,;
	$relpath =~ s,/\.,,; # chop /. 
	
	opendir(CURR_DIR, $curr_dir) or die "Something wrong cannot open .: $!";

	while($file = readdir(CURR_DIR)) {
		if ($file =~ /$imgfilepattern/ ) {
			push(@imgfiles, $file);
			print "IMG: $file \n" if ($debug);
		}
		if ( (-d "$curr_dir/$file") && ! ($file =~ /$excludepattern/ )) {
			push(@dirlist, $file);
			print "DIR: $file \n" if ($debug);
		}
	}
	closedir(CURR_DIR);

	while ($dir = shift (@dirlist)) {
		if ($recursive ? generate_makefile("$curr_dir/$dir") :
			    generate_makefile("$curr_dir/$dir", 1)) {
			unshift (@dirlistX, $dir);
		}
	}

 	unless (@imgfiles || @dirlistX){
		print "Warning: empty directory $curr_dir\n";
		return 0;
	}
	if ( -w "$curr_dir/Makefile.am"){
		open(MKFL, "<$curr_dir/Makefile.am");
		$firstline = <MKFL>;
		close(MKFL);
        	if (($firstline ne "# autogenerated file, don't touch!\n")
		    && ! $force) {
			print "$firstline\n" if ($debug);
			print "$curr_dir/Makefile.am is not autogenrated. ";
			print "Refusing to overwrite.\n";
			return 1;
		}
	} elsif ( -e "$curr_dir/Makefile.am") {
		print "Warning: cannot write $curr_dir/Makefile.am\n";
		return 1;
	}

	print "Creating Makefile.am for $curr_dir: " if ! $test;
	open(MKFL, ">$curr_dir/Makefile.am") if ! $test;
	print MKFL "# autogenerated file, don't touch!\n\n" if ! $test;

	if(@imgfiles){
		print " images" if ! $test;
		print MKFL "pkgdatadir = \$(datadir)/games/\@PACKAGE\@/$relpath\n" if ! $test;
		print MKFL "EXTRA_DIST = " if ! $test;
		if(!$test) {
			foreach(@imgfiles) {print MKFL "$_ ";}
		}
		print MKFL "\n" if ! $test;
		print MKFL "pkgdata_DATA = \$(EXTRA_DIST)\n" if ! $test;
	}

	if(@dirlistX){
		print " subdirectories" if ! $test;
		print MKFL "SUBDIRS = " if ! $test;
		if(!$test) {
			foreach(@dirlistX) {print MKFL "$_ ";}
		}
		print MKFL "\n" if ! $test;
	}

	if ($autogenerate) {
		print MKFL "Makefile.am: . \$(SUBDIRS)\n" if ! $test;
		print MKFL "\tperl \$(top_srcdir)/data/images/generate_makefile.pl -a ." if ! $test;
	}
	print "\n" if ! $test;

	print MKFL "\n# EOF #\n" if ! $test;
	close(MKFL) if ! $test;

	return 1;
}
