# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding groups example
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Florian Boucault <florian@fluendo.com>

import sys, pgm
from pgm.graph import group, image, text

# Handles the key presses
def on_key_press(viewport, event, step_size, parent_group, child_group):
    if event.keyval == pgm.keysyms.q or event.keyval == pgm.keysyms.Escape:
        pgm.main_quit()

    elif event.keyval == pgm.keysyms.Right:
        parent_group.x += step_size

    elif event.keyval == pgm.keysyms.Left:
        parent_group.x -= step_size

    elif event.keyval == pgm.keysyms.Down:
        parent_group.y += step_size

    elif event.keyval == pgm.keysyms.Up:
        parent_group.y -= step_size

    elif event.keyval == pgm.keysyms.g:
        child_group.x += step_size

    elif event.keyval == pgm.keysyms.d:
        child_group.x -= step_size

    elif event.keyval == pgm.keysyms.f:
        child_group.y += step_size

    elif event.keyval == pgm.keysyms.r:
        child_group.y -= step_size

    elif event.keyval == pgm.keysyms.e:
        parent_group.remove(child_group)

    elif event.keyval == pgm.keysyms.t:
        parent_group.add(child_group)

    elif event.keyval == pgm.keysyms.y:
        sx, sy = parent_group.size
        new_sx = sx + 0.1
        new_sy = sy + 0.1
        parent_group.size = (new_sx, new_sy)

    elif event.keyval == pgm.keysyms.h:
        sx, sy = parent_group.size
        new_sx = sx - 0.1
        new_sy = sy - 0.1
        parent_group.size = (new_sx, new_sy)

# Terminate the mainloop on a delete event
def on_delete(viewport, event):
    pgm.main_quit()


def main(args):
    # OpenGL viewport creation
    gl = pgm.viewport_factory_make('opengl')
    gl.title = 'Wrapping drawables'

    # Canvas creation
    cvs = pgm.Canvas()

    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(cvs)


    # Create text drawables
    txt1 = text.Text()
    txt1.label = "root text 1"
    txt1.height = 0.15
    txt1.size = (1.5, 0.75)
    txt1.fg_color = (255, 0, 0, 255)
    txt1.bg_color = (0, 0, 0, 255)
    txt1.visible = True
    cvs.add(pgm.DRAWABLE_MIDDLE, txt1)

    txt2 = text.Text()
    txt2.label = "root text 2"
    txt2.height = 0.25
    txt2.size = (1.5, 0.75)
    txt2.fg_color = (0, 255, 0, 255)
    txt2.bg_color = (0, 0, 0, 0)
    txt2.visible = True
    cvs.add(pgm.DRAWABLE_MIDDLE, txt2)

    txt3 = text.Text()
    txt3.label = "child text 1"
    txt3.height = 0.1
    txt3.size = (1.5, 0.75)
    txt3.fg_color = (0, 0, 255, 255)
    txt3.bg_color = (0, 0, 0, 0)
    txt3.visible = True
    cvs.add(pgm.DRAWABLE_MIDDLE, txt3)

    txt4 = text.Text()
    txt4.label = "child text 2"
    txt4.height = 0.2
    txt4.size = (1.5, 0.75)
    txt4.fg_color = (255, 0, 255, 255)
    txt4.bg_color = (0, 0, 0, 0)
    txt4.visible = True
    cvs.add(pgm.DRAWABLE_MIDDLE, txt4)

    # Create an image drawable
    img1 = image.Image()
    img1.set_from_file("examples/pictures/fluendo.png")
    img1.size = (1.0, 1.0)
    img1.bg_color = (0, 0, 0, 0)
    img1.visible = True
    cvs.add(pgm.DRAWABLE_MIDDLE, img1)


    # Create two groups, one containing the other
    child_group = group.Group(cvs, pgm.DRAWABLE_MIDDLE)
    child_group.visible = True
    child_group.position = (2.0, 1.0, 0.0)

    child_group.add(txt1)
    child_group.add(txt2)

    parent_group = group.Group(cvs, pgm.DRAWABLE_MIDDLE)
    parent_group.visible = True
    parent_group.position = (0.0, 0.0, 0.0)

    parent_group.add(txt3)
    parent_group.add(txt4)
    parent_group.add(img1)
    parent_group.add(child_group)


    # Let's start the mainloop
    gl.connect('delete-event', on_delete)
    gl.connect('key-press-event', on_key_press, 0.5, parent_group, child_group)
    gl.show()
    pgm.main()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
