<?php
	/**************************************************************************\
	* phpGroupWare                                                             *
	* http://www.phpgroupware.org                                              *
	* Written by Phill Zarfos <zarf@home.com>                                  *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: functions.inc.php,v 1.2 2001/05/07 01:03:40 zarf Exp $ */

include("../calendar/inc/functions.inc.php");

function echo_wap_header()
{
	// Necessary tags to start a WAP page...
	echo "<?xml version=\"1.0\"?>\n";
	echo "<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\"";
	echo " \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n";
}


function echo_appointments($dayName, $now, $endOfDay, $owner)
{
	global $phpgw, $phpgw_info;

	if ($phpgw_info['user']['preferences']['common']['timeformat'] == '12')
	{
		$format = 'h:i a';
	}
	else 
	{
		$format = 'H:i';
	}

	$events = $phpgw->calendar->get_sorted_by_date($now, $owner);
	$numitems = $phpgw->calendar->sorted_events_matching;
	for ($i = 0; $i < $numitems; $i++)
	{
		$item = $events[$i];

		// Print a header the first time
		if ($i == 0)
			echo "<b>Appointments for $dayName:</b><br/>\n";

		// Extract the time and title from the data structures
		$date = $phpgw->common->show_date( $item->datetime, $format ); 
		$name = $phpgw->calendar->is_private($item, $owner, 'title');
		// Print the appointment
		echo "$date: $name<br/>\n";
	}

	// Print a message if there were no calendar entries today
	if ($numitems == 0)
		echo "No appointments.<br/>\n";
}


function echo_todo($owner)
{
	global $phpgw;

	$query = "select * from phpgw_todo where todo_id_parent = 0"
	       . " and todo_owner='" . $owner . "' order by todo_pri";
	$phpgw->db->query($query, __LINE__, __FILE__);
	$counter = 0;
	while ($phpgw->db->next_record())
	{
		// Print the header the first time through this loop
    	if ($counter == 0) echo "<b>Todo List:</b><br/>\n";

		// Print the todo item
		echo get_todo_priority_symbol( $phpgw->db->f("todo_pri") );
		echo " ";
		echo $phpgw->db->f("todo_des") . "<br/>";
		//echo $phpgw->db->f("todo_status") . "<br/>";
		//echo $phpgw->db->f("todo_enddate") . "<br/>";

		// FIX: check if actual project has subprojects
		//$db2->query("select count(*) as cnt from todo where todo_id_parent=" . $phpgw->db->f("todo_id"), __LINE__, __FILE__);

		$counter++;
	}

	// Print a message if there were no todo entries
	if ($counter == 0)
		echo "Todo List is empty.<br/>\n";

}


function echo_address($letter, $owner)
{
	global $phpgw, $phpgw_info;

	// CREATE OBJECT / RUN QUERY HERE

	// PRINT EACH ENTRY THAT CAME BACK FROM THE QUERY

	$counter = 0;
	//while (*next_record)
	//{
		// Print the record
		//echo $phpgw->db->f("fn") . " " . $phpgw->db->f("email_home") . " ";
		//$pref = "tel_" . $phpgw->db->f("tel_prefer");

		// This tag should let the user dial a number:
		// <a href="wtai://wp/mc;5551212" title="Call">555-1212</a>

		//$num = $phpgw->db->f($pref);
		//echo "<a href=\"wtai://wp/mc;$num\" title=\"Call\">$num</a>";
		//echo "<br/>\n";

		//$counter++;
	//}

	// Print a message if there were no calendar entries today
	if ($counter == 0)
		echo "No match for $letter<br/>\n";
}


function get_todo_priority_symbol($pri)
{
	$ret = " ";
	if ($pri == 1)     { $ret = "."; }  // low
	else if ($pri = 2) { $ret = ":"; }  // normal
	else if ($pri = 3) { $ret = "!"; }  // urgent
	return $ret;
}

?>
