<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.sotimeperiod.inc.php,v 1.7 2001/09/06 22:56:15 bettina Exp $ */

	class sotimeperiod
	{
		var $grants;

		function sotimeperiod()
		{
			global $phpgw, $phpgw_info;

			$this->db		= $phpgw->db;
			$this->db2		= $this->db;
			$this->grants	= $phpgw->acl->get_grants('netsaint');
			$this->owner	= $phpgw_info['user']['account_id'];
		}

		function read_timeperiods($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by tp_name asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( tp_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (tp_access='public' AND tp_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " tp_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " tp_owner='" . $this->owner . "' AND tp_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND tp_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND tp_name like '%$query%' OR tp_alias like '%$query%' ";
			}

			$sql = "SELECT * FROM phpgw_ns_tp WHERE $filtermethod $searchmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$tp[$i]['id']		= $this->db->f('tp_id');
				$tp[$i]['name']		= $this->db->f('tp_name');
				$tp[$i]['access']	= $this->db->f('tp_access');
				$tp[$i]['owner']	= $this->db->f('tp_owner');
				$tp[$i]['date']		= $this->db->f('tp_date');
				$tp[$i]['cat']		= $this->db->f('tp_cat');
				$tp[$i]['alias']	= $this->db->f('tp_alias');
				$i++;
			}
			return $tp;
		}

		function read_config_timeperiods()
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_tp";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$tp[$i]['name']		= $this->db->f('tp_name');
				$tp[$i]['alias']	= $this->db->f('tp_alias');
				$tp[$i]['sun']		= $this->db->f('sun_time');
				$tp[$i]['mon']		= $this->db->f('mon_time');
				$tp[$i]['thu']		= $this->db->f('tue_time');
				$tp[$i]['wed']		= $this->db->f('wed_time');
				$tp[$i]['thu']		= $this->db->f('thu_time');
				$tp[$i]['fri']		= $this->db->f('fri_time');
				$tp[$i]['sat']		= $this->db->f('sat_time');
				$i++;
			}
			return $tp;
		}


		function read_times($start, $limit = True)
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_time ORDER BY t_value ASC";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();

			if ($limit)
			{
				$this->db->limit_query($sql,$start,__LINE__,__FILE__);
			}
			else
			{
				$this->db->query($sql,__LINE__,__FILE__);
			}

			$i = 0;
			while ($this->db->next_record())
			{
				$t[$i]['id']	= $this->db->f('t_id');
				$t[$i]['value']	= $this->db->f('t_value');
				$i++;
			}
			return $t;
		}

		function read_single_tp($tp_id)
		{
			$this->db->query("select * from phpgw_ns_tp where tp_id='$tp_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$tp['id']		= $this->db->f('tp_id');
				$tp['name']		= $this->db->f('tp_name');
				$tp['access']	= $this->db->f('tp_access');
				$tp['owner']	= $this->db->f('tp_owner');
				$tp['date']		= $this->db->f('tp_date');
				$tp['cat']		= $this->db->f('tp_cat');
				$tp['alias']	= $this->db->f('tp_alias');
				$tp['mon_time'] = $this->db->f('mon_time');
				$tp['tue_time'] = $this->db->f('tue_time');
				$tp['wed_time'] = $this->db->f('wed_time');
				$tp['thu_time'] = $this->db->f('thu_time');
				$tp['fri_time'] = $this->db->f('fri_time');
				$tp['sat_time'] = $this->db->f('sat_time');
				$tp['sun_time'] = $this->db->f('sun_time');

				return $tp;
			}
		}

		function add_timeperiod($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);

			$this->db->query("INSERT INTO phpgw_ns_tp (tp_name,tp_owner,tp_access,tp_cat,tp_date,tp_alias,sun_time,mon_time,tue_time,wed_time,thu_time,"
							."fri_time,sat_time) VALUES ('" . $values['name'] . "','" . $this->owner . "','" . $values['access'] . "','"
							. $values['cat'] . "','" . time() . "','" . $values['alias'] . "','" . $values['sun_time'] . "','" . $values['mon_time']
							. "','" . $values['tue_time'] . "','" . $values['wed_time'] . "','" . $values['thu_time'] . "','" . $values['fri_time']
							. "','" . $values['sat_time'] . "')",__LINE__,__FILE__);
		}

		function add_time($values)
		{
			$this->db->query("INSERT INTO phpgw_ns_time (t_value) VALUES ('" . $values['value'] . "')",__LINE__,__FILE__);
		}

		function edit_timeperiod($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);

			$this->db->query("UPDATE phpgw_ns_tp set tp_name='" . $values['name'] . "', tp_access='" . $values['access'] . "', tp_cat='"
							. $values['cat'] . "', tp_date='" . time() . "', tp_alias='" . $values['alias'] . "', sun_time='" . $values['sun_time']
							. "', mon_time='" . $values['mon_time'] . "', tue_time='" . $values['tue_time'] . "', wed_time='" . $values['wed_time']
							. "', thu_time='" . $values['thu_time'] . "', fri_time='" . $values['fri_time'] . "', sat_time='" . $values['sat_time']
							. "' WHERE tp_id='" . $values['id'] . "'",__LINE__,__FILE__);
		}

		function delete_timeperiod($tp_id)
		{
			$this->db->query("DELETE FROM phpgw_ns_tp WHERE tp_id='$tp_id'",__LINE__,__FILE__);
		}

		function delete_time($t_id)
		{
			$this->db->query("DELETE FROM phpgw_ns_time WHERE t_id='$t_id'",__LINE__,__FILE__);
		}

		function exists($tp_name, $tp_id = '')
		{
			if ($tp_id && ($tp_id != 0))
			{
				$editexists = " and tp_id != '$tp_id'";
			}

			$this->db->query("select count(*) from phpgw_ns_tp where tp_name = '$tp_name' $editexists",__LINE__,__FILE__);
			$this->db->next_record();

			if ($this->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function select_tp_list($selected = '')
		{
			global $phpgw;

			$tp = $this->read_timeperiods($start, False, $query, $filter, $sort, $order, $cat_id);

			for ($i=0;$i<count($tp);$i++)
			{
				$tp_select .= '<option value="' . $tp[$i]['name'] . '"';
				if ($tp[$i]['name'] == $selected)
				{
					$tp_select .= ' selected';
				}
				$tp_select .= '>' . $phpgw->strip_html($tp[$i]['name']) . '</option>';
			}
			return $tp_select;
		}

		function in_array($needle,$haystack)
		{
			if (function_exists('in_array'))
			{
				return in_array($needle,$haystack);
			}
			while (list ($k,$v) = each($haystack))
			{
				if ($v == $needle)
				{
					return True;
				}
			}
			return False;
		}

		function select_time_list($selected = '')
		{
			global $phpgw;

			if (!is_array($selected))
			{
				$selected = explode(',',$selected);
			}

			$t = $this->read_times($start, False);
	
			for ($i=0;$i<count($t);$i++)
			{
				$t_select .= '<option value="' . $t[$i]['value'] . '"';
				if ($this->in_array($t[$i]['value'],$selected))
				{
					$t_select .= ' selected';
				}
				$t_select .= '>' . $t[$i]['value'] . '</option>';
			}
			return $t_select;
		}
	}
?>
