<?php
  /**************************************************************************\
  * phpGroupWare - Chora CVS Repositories                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: sites.php,v 1.9 2001/07/25 23:34:57 milosch Exp $ */

	$phpgw_info["flags"] = array(
		'currentapp' => 'chora',
		'enable_config_class' => True,
		'enable_nextmatchs_class' => True);

	include('../header.inc.php');

	if(!$phpgw->acl->check('run',1,'admin'))
	{
		echo lang('access not permitted');
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();

	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('site_list_t' => 'listsites.tpl'));
	$t->set_block('site_list_t','site_list','list');

	$common_hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
		. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
		. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
		. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";

	$t->set_var('lang_action',lang('Repository List'));
	$t->set_var('add_action',$phpgw->link('/chora/addsite.php'));
	$t->set_var('lang_add',lang('Add'));
	$t->set_var('title_sites',lang('CVS Repositories'));
	$t->set_var('lang_search',lang('Search'));
	$t->set_var('actionurl',$phpgw->link('/chora/sites.php'));
	$t->set_var('lang_done',lang('Done'));
	$t->set_var('doneurl',$phpgw->link('/admin/index.php'));

	if (!$start) { $start = 0; }

	if($phpgw_info["user"]["preferences"]["common"]["maxmatchs"] && $phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > 0)
	{
		$limit = $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
	}
	else
	{
		$limit = 15;
	}

	if (!$sort) { $sort = "ASC"; }
	if ($order) { $ordermethod = "order by $order $sort "; }
	else { $ordermethod = " order by name asc "; }

	if ($query)
	{
		$querymethod = " WHERE name like '%$query%' OR title like '%$query%'";
	}

	$db2 = $phpgw->db;

	$sql = "SELECT * FROM phpgw_chora_sites $querymethod $ordermethod";
	$db2->query($sql,__LINE__,__FILE__);
	$total_records = $db2->num_rows();
	$phpgw->db->limit_query($sql,$start,__LINE__,__FILE__);
	while ($phpgw->db->next_record())
	{
		$sites[] = array(
			'id'          => $phpgw->db->f('id'),
			'name'        => $phpgw->db->f('name'),
			'location'    => $phpgw->db->f('location'),
			'title'       => $phpgw->db->f('title'),
			'is_default'  => $phpgw->db->f('is_default')
		);
	}


//--------------------------------- nextmatch --------------------------------------------

	$left = $phpgw->nextmatchs->left('/chora/sites.php',$start,$total_records);
	$right = $phpgw->nextmatchs->right('/chora/sites.php',$start,$total_records);
	$t->set_var('left',$left);
	$t->set_var('right',$right);

	if ($total_records > $limit)
	{
		$t->set_var('lang_showing',lang("showing x - x of x",($start + 1),($start + $limit),$total_records));
	}
	else
	{
		$t->set_var('lang_showing',lang("showing x",$total_records));
	}

// ------------------------------ end nextmatch ------------------------------------------

//------------------- list header variable template-declarations ------------------------- 

	$t->set_var('th_bg',$phpgw_info["theme"][th_bg]);
	$t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order($sort,'name',$order,'/chora/sites.php',lang('Name')));
	$t->set_var('sort_title',$phpgw->nextmatchs->show_sort_order($sort,'title',$order,'/chora/sites.php',lang('Title')));
	$t->set_var('lang_default',lang('Default'));
	$t->set_var('lang_edit',lang('Edit'));
	$t->set_var('lang_delete',lang('Delete'));

// -------------------------- end header declaration --------------------------------------

	for ($i=0;$i<count($sites);$i++)
	{
		$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
		$t->set_var(tr_color,$tr_color);
		$site_id = $sites[$i]['id'];
		$is_default = $sites[$i]['is_default'];
		$site_name  = $phpgw->strip_html($sites[$i]['name']);
		$site_title = $phpgw->strip_html($sites[$i]['title']);
		if (! $site_title) { $site_title= '&nbsp;'; }
//-------------------------- template declaration for list records ---------------------------

		$t->set_var(array(
			'site_name'  => $site_name,
			'site_title' => $site_title
		));
		if ($is_default)
		{
			$t->set_var('is_default',lang('Yes'));
		}
		else
		{
			$t->set_var('is_default',lang('No'));
		}

		$t->set_var('edit',$phpgw->link('/chora/editsite.php',"site_id=$site_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$t->set_var('lang_edit_entry',lang('Edit'));

		$t->set_var('delete',$phpgw->link('/chora/deletesite.php',"site_id=$site_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$t->set_var('lang_delete_entry',lang('Delete'));
		$t->parse('list','site_list',True);
	}
// ---------------------------- end record declaration -----------------------------------------

	$t->parse('out','site_list_t',True);
	$t->p('out');

	$phpgw->common->phpgw_footer();
?>
