<?php
/*
 * $Id: class.htmlPersonnel.inc.php,v 1.4 2001/05/31 05:24:57 themaniac Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */



class htmlPersonnel
{
	function createCombo($default = 0, $cbName = 'responsible', $longShort = 'lastfirst', $size = 0, $activeOnly = true, $minsec = 0, $projectid = 0)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly, $minsec, $projectid);
	}

	function GetCombo($default = 0, $cbName = 'responsible', $longShort = 'lastfirst', $size = 0, $activeOnly = true, $minsec = 0, $projectid = 0)
	{
		$objDBPersonnel = CreateObject('ccs.dbPersonnel');
		$objAccount = CreateObject('phpgwapi.accounts');

		// $objDBPersonnel->cacheEnabled = false;

		//if ($longShort == 'lastfirst')
		//$orderBy = 'lastname, firstname';
		//else if ($longShort == 'firstlast' || $longShort == 'name')
		//$orderBy = 'firstname, lastname';
		//else
		$orderBy = 'id';
		$activeOnly = false; //should play with this some day

		if ($projectid > 0)
		{
				// Show people in the project only
			$query = "SELECT DISTINCT osims_personnel.* FROM personnel ";
			$query .= ', workorders a, projectmap b WHERE ';
			$query .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid=$projectid ";
			$query .= 'AND id=a.responsible ';
		}
		else
		{
			$query = "SELECT * FROM osims_personnel ";
			if ($activeOnly)
				$query .= 'WHERE active=\'Y\' ';

			if ($minsec > 0)
			{
				if ($activeOnly)
					$query .= 'AND';
				else
					$query .= 'WHERE';

				$query .= " security>=$minsec ";
			}
		}

		$query .= "ORDER BY $orderBy";
		$objDBPersonnel->db->query($query);

		$str = "<select name=\"$cbName";

		if ($size > 0)
			$str .= '[]" multiple size="' . $size . '"';
		else
			$str .= '"';

		$str .= '>';
		if ($size == 0)
			$str .= sprintf('<option value="0">%s</option>', 'Select User');

		while ($objDBPersonnel->db->next_record() )
		{
			//$objDBPersonnel->GetRow();
			$str .= '<option value="'. $objDBPersonnel->db->f('id') . '"';
			if ($objDBPersonnel->db->f('id') == $default)
				$str .= ' selected';
			$str .= '>';

			//	if ($longShort == 'lastfirst')
			//$str .= $objDBPersonnel->lastNameFirst;
			//else if ($longShort == 'firstlast' || $longShort == 'name')
			//$str .= $objDBPersonnel->firstNameLast;
			//else
			$name = $objAccount->id2name($objDBPersonnel->db->f('phpgwid'));
			$str .= $name;

			$str .= '</option>';

			//	if ($objDBPersonnel->next_record() == -1)
			//break;
		}

		$str .= '</select>';

		return $str;
	}

	function displayPasswdForm()
	{
		global $dcl_info;

		$Template = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('ccs'));
		$Template->set_file(array('hForm' => 'htmlPersonnelPasswdForm.tpl'));
		$Template->set_block('hForm', 'sa', 'hSa');
		$Template->set_block('hForm', 'notsa', 'hNotSa');
		$Template->set_var('hSa', '');
		$Template->set_var('hNotSa', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_CHGPWD', STR_USR_CHGPWD);

		$hidden_vars = '<input type="hidden" name="menuAction" value="ccs.boPersonnel.dbpasswd">';
		if ($GLOBALS['DCLID'] > 1)
		{
			$hidden_vars .= sprintf('<input type="hidden" name="userid" value="%d">', $GLOBALS['DCLID']);
			$Template->set_var('TXT_CURRPWD', STR_USR_CURRPWD);
			$Template->parse('hNotSa', 'notsa');
		}
		else
		{
			$Template->set_var('TXT_USER', STR_USR_USER);
			$Template->set_var('CMB_USERID', $this->GetCombo($GLOBALS['DCLID'], 'userid'));
			$Template->parse('hSa', 'sa');
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);
		$Template->set_var('TXT_NEWPWD', STR_USR_NEWPWD);
		$Template->set_var('TXT_CONFIRMPWD', STR_USR_CONFIRMPWD);
		$Template->set_var('BTN_CHANGE', STR_USR_CHANGE);
		$Template->set_var('BTN_CLEAR', STR_USR_CLEAR);

		$Template->pparse('out', 'hForm');
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info,$phpgw;
		$accounts = CreateObject('phpgwapi.accounts');
		$isEdit = is_object($obj);
		$Template = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('ccs'));
		$Template->set_file(array('hForm' => 'htmlPersonnelForm.tpl'));
		$Template->set_block('hForm', 'add', 'hAdd');
		$Template->set_block('hForm', 'edit', 'hEdit');
		$Template->set_block('hForm', 'list', 'hList');
		$Template->set_var('hAdd', '');
		$Template->set_var('hEdit', '');
		$Template->set_var('hList', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', 'Edit User');
			$hidden_vars = '<input type="hidden" name="menuAction" value="ccs.boPersonnel.dbmodify">' .
				'<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', 'Add User');
			$hidden_vars = '<input type="hidden" name="menuAction" value="ccs.boPersonnel.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

			// Labels
		$Template->set_var('TXT_LOGIN', 'phpGW login Name');
		$Template->set_var('TXT_ACTIVE', 'Active');
		//	$Template->set_var('TXT_FIRSTNAME', STR_USR_FIRSTNAME);
		//	$Template->set_var('TXT_LASTNAME', STR_USR_LASTNAME);
		$Template->set_var('TXT_REPORTTO', 'Reports To');
		$Template->set_var('TXT_DEPARTMENT', 'Department');
		//	$Template->set_var('TXT_PASSWORD', STR_USR_PASSWORD);
		$Template->set_var('TXT_SECLVL', 'Security Level');
		//	$Template->set_var('TXT_CONFIRMPWD', STR_USR_CONFIRMPWD);
		//$Template->set_var('TXT_EMAIL', STR_USR_EMAIL);
		$Template->set_var('BTN_SAVE', 'Save');
		$Template->set_var('BTN_RESET', 'Reset');
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_USR_HIGHLIGHTEDNOTE);

			// Security Info
		$Template->set_var('TXT_MINLVL', STR_USR_MINLVL);
		$Template->set_var('TXT_TODOTHIS', STR_USR_TODOTHIS);

		$Template->set_var('TXT_LVL', $dcl_info['DCL_ADD_USER']);
		$Template->set_var('TXT_DESC', STR_USR_ADMIN);
		$Template->parse('hList', 'list', true);
		$Template->set_var('TXT_LVL', $dcl_info['DCL_DEL_WO']);
		$Template->set_var('TXT_DESC', STR_USR_DELWO);
		$Template->parse('hList', 'list', true);
		$Template->set_var('TXT_LVL', $dcl_info['DCL_MOD_WO']);
		$Template->set_var('TXT_DESC', STR_USR_MODWO);
		$Template->parse('hList', 'list', true);
		$Template->set_var('TXT_LVL', $dcl_info['DCL_ASSIGN_WO']);
		$Template->set_var('TXT_DESC', STR_USR_ADDASSGN);
		$Template->parse('hList', 'list', true);
		$Template->set_var('TXT_LVL', $dcl_info['DCL_HAVE_WO']);
		$Template->set_var('TXT_DESC', STR_USR_RESPONSIBLE);
		$Template->parse('hList', 'list', true);
		$Template->set_var('TXT_LVL', $dcl_info['DCL_CHG_PWD']);
		$Template->set_var('TXT_DESC', STR_USR_CANCHGPWD);
		$Template->parse('hList', 'list', true);
		$Template->set_var('TXT_LVL', $dcl_info['DCL_ADD_WO']);
		$Template->set_var('TXT_DESC', STR_USR_ADDWO);
		$Template->parse('hList', 'list', true);

		$objHTMLDepartments = CreateObject('ccs.htmlDepartments');

			// Data
		if ($isEdit)
		{
			$phpgwid = $obj->phpgwid;
			$Template->set_var('VAL_SHORT', $accounts->id2name($phpgwid));
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_FIRSTNAME', $obj->firstname);
			$Template->set_var('VAL_LASTNAME', $obj->lastname);
			$Template->set_var('CMB_REPORTTO', $this->GetCombo($obj->reportto, 'reportto'));
			$Template->set_var('CMB_DEPARTMENT', $objHTMLDepartments->GetCombo($obj->department));
			$Template->set_var('VAL_SECURITY', $obj->security);
			$Template->set_var('VAL_EMAIL', $obj->email);
			$Template->parse('hEdit', 'edit');
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('CMB_REPORTTO', $this->GetCombo($GLOBALS['DCLID'], 'reportto'));
			$Template->set_var('CMB_DEPARTMENT', $objHTMLDepartments->GetCombo());
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_FIRSTNAME', '');
			$Template->set_var('VAL_LASTNAME', '');
			$Template->set_var('VAL_SECURITY', '');
			$Template->set_var('VAL_EMAIL', '');
			$Template->parse('hAdd', 'add');
		}			

		$Template->pparse('out', 'hForm');
	}

	function PrintAll($orderBy = 'id')
	{
		global $dcl_info;

		$objDBPersonnel = CreateObject('ccs.dbPersonnel');

		$objDBPersonnel->db->query("SELECT id,active,phpgwid,reportto,department,security FROM osims_personnel ORDER BY $orderBy");
		$allRecs = $objDBPersonnel->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="alight" href="index.php?menuAction=ccs.boPersonnel.add">[ ' . 'New' . ' ]</a>';
		else
			$titleLink = '';

		if (is_array($allRecs))
		{
                // Replace all the id fields with meaningful text
			$objDBDept = CreateObject('ccs.dbDepartments');
			//	$objDBDept->Connect($objDBPersonnel->conn);
			/*	for ($i = 0; $i < count($allRecs); $i++)
			{
				$objDBPersonnel->Load($allRecs[$i][5]);
				$objDBDept->Load($allRecs[$i][6]);
				$allRecs[$i][5] = $objDBPersonnel->short;
				$allRecs[$i][6] = $objDBDept->name;
				if (IsSet($allRecs[$i][8]) && $allRecs[$i][8] != '')
					$allRecs[$i][8] = '<a class="adark" href="mailto:' . $allRecs[$i][8] . '">' . $allRecs[$i][8] . '</a>';
			} */

			$allName = array(
					0 => 'ID', 
					1 => 'Active', 
					2 => 'phpgwID', 
					//	3 => STR_USR_LASTNAME, 
					//	4 => STR_USR_FIRSTNAME,
					3=> 'Report To', 
					4=> 'Department', 
					5=>  'Security Level'); 
					// 8 => STR_USR_EMAIL);

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = 'Options';
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="index.php?menuAction=ccs.boPersonnel.modify&id=' . $allRecs[$i][0] . '">' . Edit . '</a>';
					$options .= "&nbsp;";
					$options .= '<a class="adark" href="index.php?menuAction=ccs.boPersonnel.delete&id=' . $allRecs[$i][0] . '">' . Delete . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, sprintf('Personnel', $orderBy), '', $titleLink);
		}
		else
		{
			print('<center>');
			PrintWithChocoFont(STR_USR_NOUSERS . '&nbsp;&nbsp;' . $titleLink);
			print('</center>');
		}
	}
}
?>
