<?php
  /**************************************************************************\
  * phpGroupWare - Brewer Main Brew Calc                                     *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: beer.php,v 1.7 2001/09/11 12:38:28 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'brewer',
		'noheader'   => True,
		'nonavbar'   => True,
		'enable_sbox_class' => True,
		'enable_nextmatchs_class' => True
	);

	include('../header.inc.php');
	$DEBUG = 0;

	$action = $HTTP_POST_VARS['action']  ? $HTTP_POST_VARS['action']  : $HTTP_GET_VARS['action'];
	$clean  = $HTTP_POST_VARS['clean']  ? $HTTP_POST_VARS['clean']  : $HTTP_GET_VARS['clean'];
	$cancel = $HTTP_POST_VARS['cancel'] ? $HTTP_POST_VARS['cancel'] : $HTTP_GET_VARS['cancel'];
	$recalc = $HTTP_POST_VARS['recalc'] ? $HTTP_POST_VARS['recalc'] : $HTTP_GET_VARS['recalc'];
	$save   = $HTTP_POST_VARS['save']   ? $HTTP_POST_VARS['save']   : $HTTP_GET_VARS['save'];
	$delete = $HTTP_POST_VARS['delete'] ? $HTTP_POST_VARS['delete'] : $HTTP_GET_VARS['delete'];

	$id = $HTTP_POST_VARS['id'] ? $HTTP_POST_VARS['id'] : $HTTP_GET_VARS['id'];
	
	$add_ingredient = $HTTP_POST_VARS['add_ingredient'] ? $HTTP_POST_VARS['add_ingredient'] : $HTTP_GET_VARS['add_ingredient'];
	$newval         = $HTTP_POST_VARS['newval'];
	$ingredients    = $HTTP_POST_VARS['ingredients'];
	$malt_units     = $HTTP_POST_VARS['malt_units'];
	$yeast_units    = $HTTP_POST_VARS['yeast_units'];
	$hop_units      = $HTTP_POST_VARS['hop_units'];

	$b = CreateObject('brewer.brew');
	$r = $b->recipe;

	if($clean)
	{
		$mt = array();
		$b->save_sessiondata($mt);
	}
	if ($cancel)
	{
		$mt = array();
		$b->save_sessiondata($mt);
		Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/recipes.php'));
	}
	elseif($recalc)
	{
		$action = 'recalc';
	}
	elseif($save)
	{
		$action = 'set';
	}
	elseif($delete)
	{
		$action = 'delete';
	}
	elseif($add_ingredient)
	{
		Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/index.php',"mode=select"));
	}

	if($newval || $ingredients || $malt_units || $yeast_units || $hop_units)
	{
		/* print_r($newval); */
		$r->recipe = $b->read_sessiondata();
		if ($newval)
		{
			@reset($newval);
			while(list($key,$val) = each($newval))
			{
				$r->recipe[$key] = $val;
			}
		}
		/* This is for updating quanties from the dynamic ingredient list. */
		if ($ingredients)
		{
			while(list($key,$val) = each($ingredients))
			{
				list($itype,$ikey) = explode('_',$key);
				$amt  = $itype . '_amounts';
				$unit = $itype . '_units';
				/* echo '<br>' . $amt . '[' . $ikey . ']=' . $val; */
				$r->recipe[$amt][$ikey]  = $val;
			}
		}
		if ($malt_units != '')
		{
			$r->recipe['malt_units'] = $malt_units;
		}
		if ($yeast_units != '')
		{
			$r->recipe['yeast_units'] = $yeast_units;
		}
		if ($hop_units != '')
		{
			$r->recipe['hop_units'] = $hop_units;
		}
		$b->save_sessiondata($r->recipe);
	}

	/* $action is the called or set action */
	switch($action)
	{
		case 'get':
			$tmp = $r->get($id);
			$r->recipe = $tmp[$id];
			$b->save_sessiondata($r->recipe);
			break;
		case 'list':
			Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/recipes.php'));
			/* this works */
			break;
		case 'set':
			$r->recipe = $b->read_sessiondata();
			$id = $r->set($id);
			$r->recipe = $r->get($id);
			$b->save_sessiondata($r->recipe);
			break;
		case 'addingredient':
			$r->recipe = $b->read_sessiondata();
			$b->add_ingredient($r,$type,$id);
			$id = $r->recipe['id'];
			break;
		case 'removeingredient':
			$r->recipe = $b->read_sessiondata();
			$b->remove_ingredient($r->recipe,$type,$id);
			$r->recipe = $b->read_sessiondata();
			$id = $r->recipe['id'];
			break;
		case 'recalc':
			$b->recipe->recipe = $b->read_sessiondata();
			$r->recalc($b);
			break;
		case 'new':
			$r->recipe = $r->data;
			$b->save_sessiondata($r->recipe);
			//$extra_tpls[] = 'add_ing';
			/* this works */
			break;
		case 'delete':
			Header('Location: ' . $GLOBALS['phpgw']->link('/brewer/delete.php',"type=recipe&id=$id"));
			break;
		default:
			break;
	}

	$r->recipe = $b->read_sessiondata();

	$GLOBALS['phpgw']->common->phpgw_header();
	echo parse_navbar();

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$GLOBALS['phpgw']->template->set_file(array('disp' => 'recipe_form.tpl'));
	$GLOBALS['phpgw']->template->set_block('disp','header','header');
	$GLOBALS['phpgw']->template->set_block('disp','main','main');
	$GLOBALS['phpgw']->template->set_block('disp','ingredient','ingredient');
	$GLOBALS['phpgw']->template->set_block('disp','detail','detail');
	$GLOBALS['phpgw']->template->set_block('disp','buttons','buttons');
	$GLOBALS['phpgw']->template->set_block('disp','results','results');
	$GLOBALS['phpgw']->template->set_block('disp','brew_style','brew_style');
	$GLOBALS['phpgw']->template->set_block('disp','footer','footer');

	@reset($extra_tpls);
	while (list($key,$val) = @each($extra_tpls))
	{
		$GLOBALS['phpgw']->template->set_block('disp',$val,$val);
	}

	/* Basic brew info and form url */
	$GLOBALS['phpgw']->template->set_var('title',lang('Brewer') . ' - ' . lang('Recipe Editor'));
	$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/brewer/beer.php'));
	$GLOBALS['phpgw']->template->set_var('lang_name',lang('Recipe Name'));
	$GLOBALS['phpgw']->template->set_var('name',$r->recipe['name']);
	$GLOBALS['phpgw']->template->set_var('id',$id);

	/* Themes and colors */
	$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('th_text',$GLOBALS['phpgw_info']['theme']['th_text']);
	$GLOBALS['phpgw']->template->set_var('row_on',$GLOBALS['phpgw_info']['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$GLOBALS['phpgw_info']['theme']['row_off']);

	/* Brew settings/methods (detail) */
	$GLOBALS['phpgw']->template->set_var('lang_detail',lang('Brew Settings'));
	$GLOBALS['phpgw']->template->set_var('lang_setting',lang('Setting'));
	$GLOBALS['phpgw']->template->set_var('lang_value',lang('Value'));
	$GLOBALS['phpgw']->template->set_var('lang_units',lang('Units'));

	$GLOBALS['phpgw']->template->set_var('lang_boil_vol',lang('Boil Volume'));
	$GLOBALS['phpgw']->template->set_var('boil_vol',$r->recipe['boil_vol']);
	$GLOBALS['phpgw']->template->set_var('boil_units',formatted_list('newval[boil_units]',$r->volume_units,$r->recipe['boil_units']));
	$GLOBALS['phpgw']->template->set_var('lang_boil_time',lang('Boil Time'));
	$GLOBALS['phpgw']->template->set_var('lang_time_units',lang('minutes'));
	$GLOBALS['phpgw']->template->set_var('boil_time',$r->recipe['boil_time']);
	$GLOBALS['phpgw']->template->set_var('lang_total_vol',lang('Total Volume'));
	$GLOBALS['phpgw']->template->set_var('total_vol',$r->recipe['total_vol']);
	$GLOBALS['phpgw']->template->set_var('vol_units',formatted_list('newval[vol_units]',$r->volume_units,$r->recipe['vol_units']));

	$GLOBALS['phpgw']->template->set_var('lang_IBU_Method',lang('IBU Method'));
	$GLOBALS['phpgw']->template->set_var('IBU_Method',formatted_list('newval[IBU_method]',$r->IBU_method_names,$r->recipe['IBU_method']));

	/* Ingredients */
	$GLOBALS['phpgw']->template->set_var('lang_ingredients',lang('Ingredients'));
	$GLOBALS['phpgw']->template->set_var('lang_ingredient',lang('Ingredient'));
	$GLOBALS['phpgw']->template->set_var('lang_remove',lang('Remove'));

	$ing = array('malt','yeast','hop');
	while(list($x,$type) = each($ing))
	{
		$types = $type . 's';
		while(list($key,$val) = @each($r->recipe[$types]))
		{
			$type_units = $type . '_weight_units';
			$type_amounts = $type.'_amounts';
			$ev = '$tmp = $b->$type->get($val);';
			eval($ev);
			$ingred = $tmp[$val];
			$GLOBALS['phpgw']->template->set_var('ingred',($key+1) . ': ' . ucfirst($type) . ' - ' . $ingred['name']);
			$GLOBALS['phpgw']->template->set_var('ingred_id',"ingredients[$type" . '_' . $key . ']');
			$GLOBALS['phpgw']->template->set_var('amount',$r->recipe[$type_amounts][$key]);
			$GLOBALS['phpgw']->template->set_var('units',formatted_list($type . '_units',$r->$type_units,$r->recipe[$type . '_units'],False));
		/*	if($type == 'hop')
			{
				$check[$r->recipe['bitter'][$key]] = ' checked';
				$clang[0] = lang('Finish');
				$clang[1] = lang('Bitter');
				for($i=0;$i<2;$i++)
				{
					$GLOBALS['phpgw']->template->set_var('radio' . $i,'<input type="radio" name="bitter_' . $key . '" value="' . $i . '"' . $check[$r->recipe['bitter'][$key]] . '>' . $clang[$i]);
				}
			}
			else
			{*/
				$GLOBALS['phpgw']->template->set_var('radio0','');
				$GLOBALS['phpgw']->template->set_var('radio1','');
	/*		}*/
			$GLOBALS['phpgw']->template->set_var('lang_remove',lang('Remove'));
			$GLOBALS['phpgw']->template->set_var('lang_amount',lang('Amount'));
			$GLOBALS['phpgw']->template->set_var('lang_units',lang('Units'));
			$GLOBALS['phpgw']->template->set_var('remove',$GLOBALS['phpgw']->link('/brewer/beer.php',"action=removeingredient&id=$key&type=$type"));
			$GLOBALS['phpgw']->template->fp('ingredients','ingredient',True);
		}
	}

	/* Results (Output data) */
	$GLOBALS['phpgw']->template->set_var('lang_results',lang('Results'));
	$GLOBALS['phpgw']->template->set_var('extraction_efficiency',$r->recipe['extraction_efficiency']);
	$GLOBALS['phpgw']->template->set_var('lang_extraction_efficiency',lang('Extraction Efficiency'));
	$GLOBALS['phpgw']->template->set_var('apparent_attenuation',$r->recipe['apparent_attenuation']);
	$GLOBALS['phpgw']->template->set_var('lang_apparent_attenuation',lang('Apparent Attenuation'));
	$GLOBALS['phpgw']->template->set_var('real_attenuation',$r->recipe['real_attenuation']);
	$GLOBALS['phpgw']->template->set_var('lang_real_attenuation',lang('Real Attenuation'));
	$GLOBALS['phpgw']->template->set_var('original_gravity',$r->recipe['original_gravity']);
	$GLOBALS['phpgw']->template->set_var('lang_original_gravity',lang('Original Gravity'));
	$GLOBALS['phpgw']->template->set_var('final_gravity',$r->recipe['final_gravity']);
	$GLOBALS['phpgw']->template->set_var('lang_final_gravity',lang('Final Gravity'));
	$GLOBALS['phpgw']->template->set_var('alcohol_by_volume',$r->recipe['alcohol_by_volume']);
	$GLOBALS['phpgw']->template->set_var('lang_alcohol_by_volume',lang('Alcohol by volume'));
	$GLOBALS['phpgw']->template->set_var('alcohol_by_weight',$r->recipe['alcohol_by_weight']);
	$GLOBALS['phpgw']->template->set_var('lang_alcohol_by_weight',lang('Alcohol By Weight'));
	$GLOBALS['phpgw']->template->set_var('color',$r->recipe['color']);
	$GLOBALS['phpgw']->template->set_var('lang_color',lang('Color'));
	$GLOBALS['phpgw']->template->set_var('lang_IBUs',lang('IBUs'));
	$GLOBALS['phpgw']->template->set_var('IBUs',$r->recipe['IBUs']);
	$GLOBALS['phpgw']->template->set_var('lang_hop_utilization',lang('Hop Utilization'));
	$GLOBALS['phpgw']->template->set_var('hop_utilization',$r->recipe['hop_utilization']);

	/* Style information for comparison */
	$tmp = $b->style->get($r->recipe['style']);
	$style = $tmp[$r->recipe['style']];
	$GLOBALS['phpgw']->template->set_var('lang_warn',lang('Warning! Changing style will reset the recipe!'));
	$GLOBALS['phpgw']->template->set_var('style',$b->style->formatted_list($r->recipe['style'], 'style', False));
	$GLOBALS['phpgw']->template->set_var('lang_style',lang('Style'));
	$GLOBALS['phpgw']->template->set_var('lang_description',lang('Description'));
	$GLOBALS['phpgw']->template->set_var('description',$style['description']);
    $GLOBALS['phpgw']->template->set_var('lang_mingravity',lang('Minimum Gravity'));
    $GLOBALS['phpgw']->template->set_var('lang_maxgravity',lang('Maximum Gravity'));
    $GLOBALS['phpgw']->template->set_var('lang_minalcohol',lang('Minimum Alcohol %'));
    $GLOBALS['phpgw']->template->set_var('lang_maxalcohol',lang('Maximum Alcohol %'));
    $GLOBALS['phpgw']->template->set_var('lang_mincolor',lang('Minimum Color'));
    $GLOBALS['phpgw']->template->set_var('lang_maxcolor',lang('Maximum Color'));
    $GLOBALS['phpgw']->template->set_var('lang_minbitter',lang('Minimum IBU'));
    $GLOBALS['phpgw']->template->set_var('lang_maxbitter',lang('Maximum IBU'));
    $GLOBALS['phpgw']->template->set_var('mingravity',$style['mingravity']);
    $GLOBALS['phpgw']->template->set_var('maxgravity',$style['maxgravity']);
    $GLOBALS['phpgw']->template->set_var('minalcohol',$style['minalcohol']);
    $GLOBALS['phpgw']->template->set_var('maxalcohol',$style['maxalcohol']);
    $GLOBALS['phpgw']->template->set_var('mincolor', $style['mincolor']);
    $GLOBALS['phpgw']->template->set_var('maxcolor', $style['maxcolor']);
    $GLOBALS['phpgw']->template->set_var('minbitter', $style['minbitter']);
    $GLOBALS['phpgw']->template->set_var('maxbitter', $style['maxbitter']);

	/* Buttons, etc. */
	$GLOBALS['phpgw']->template->set_var('uparrow',PHPGW_IMAGES . '/up.gif');
	$GLOBALS['phpgw']->template->set_var('dnarrow',PHPGW_IMAGES . '/down.gif');
	$GLOBALS['phpgw']->template->set_var('lang_recalc',lang('Recalculate'));
	$GLOBALS['phpgw']->template->set_var('lang_add_ingredient',lang('Add Ingredient'));
	$GLOBALS['phpgw']->template->set_var('lang_select',lang('Select'));
	$GLOBALS['phpgw']->template->set_var('lang_done',lang('Done'));
	$GLOBALS['phpgw']->template->set_var('lang_update',lang('Update'));
	$GLOBALS['phpgw']->template->set_var('lang_save',lang('Save'));
	$GLOBALS['phpgw']->template->set_var('lang_delete',lang('Delete'));
	$GLOBALS['phpgw']->template->set_var('lang_cancel',lang('Cancel'));

	/* Print it */
	$GLOBALS['phpgw']->template->fp('out','header',True);
	$GLOBALS['phpgw']->template->fp('out','detail',True);
	$GLOBALS['phpgw']->template->fp('out','main',True);
	$GLOBALS['phpgw']->template->fp('out','buttons',True);
	$GLOBALS['phpgw']->template->fp('out','results',True);
	$GLOBALS['phpgw']->template->fp('out','brew_style',True);

	@reset($extra_tpls);
	while (list($key,$val) = @each($extra_tpls))
	{
		$GLOBALS['phpgw']->template->fp('out',$tmp['name']);
	}

	$GLOBALS['phpgw']->template->fp('out','footer',True);
	$GLOBALS['phpgw']->template->p('out');

	if($DEBUG)
	{
		echo '<pre>';
		print_r($r->recipe);
		echo '</pre>';
	}

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
