<?php
/**
* This file is part of French (Casual Honorifics) phpBB Translation.
* Copyright (C) 2010 phpBB.fr
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* acp_email [French (Casual Honorifics)]
*
* @package   language
* @author    Maël Soucaze <maelsoucaze@phpbb.fr> (Maël Soucaze) http://www.phpbb.fr/
* @copyright 2005 phpBB Group
* @license   http://www.gnu.org/licenses/gpl-2.0.txt GNU General Public License
* @version   $Id: email.php 8479 2008-03-29 00:22:48Z naderman $
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Email settings
$lang = array_merge($lang, array(
	'ACP_MASS_EMAIL_EXPLAIN'		=> 'Tu peux envoyer ici un e-mail à tous tes utilisateurs ou aux groupes d’utilisateurs <strong>ayant activés la réception des e-mails de masse</strong>. Pour cela, un e-mail sera envoyé à l’adresse e-mail fournie par l’administrateur et une copie sera adressée à tous les destinataires. Le réglage par défaut n’inclut que 50 destinataires par e-mail car plus il y a de destinataires, plus le temps d’attente est important. Il est normal que l’envoi d’un e-mail de masse prenne du temps, tu seras averti lorsque l’opération sera terminée.',
	'ALL_USERS'						=> 'Tous les utilisateurs',

	'COMPOSE'				=> 'Composer',

	'EMAIL_SEND_ERROR'		=> 'Des erreurs sont survenues lors de l’envoi de l’e-mail. Pour plus d’informations, consulte l’%shistorique des erreurs%s.',
	'EMAIL_SENT'			=> 'Ce message a été envoyé.',
	'EMAIL_SENT_QUEUE'		=> 'Ce message a été placé en file d’attente.',

	'LOG_SESSION'			=> 'Historique de la session e-mail vers l’historique des erreurs critiques',

	'SEND_IMMEDIATELY'		=> 'Envoyer immédiatement',
	'SEND_TO_GROUP'			=> 'Envoyer au groupe',
	'SEND_TO_USERS'			=> 'Envoyer aux utilisateurs',
	'SEND_TO_USERS_EXPLAIN'	=> 'Les noms sélectionnés ici écraseront n’importe quel groupe sélectionné ci-dessus. Saisi chaque nom d’utilisateur sur une nouvelle ligne.',
	
	'MAIL_HIGH_PRIORITY'	=> 'Élevée',
	'MAIL_LOW_PRIORITY'		=> 'Faible',
	'MAIL_NORMAL_PRIORITY'	=> 'Normale',
	'MAIL_PRIORITY'			=> 'Priorité de l’e-mail',
	'MASS_MESSAGE'			=> 'Ton message',
	'MASS_MESSAGE_EXPLAIN'	=> 'Sache que tu ne dois saisir que du texte brut. Toutes les balises seront automatiquement supprimées lors de l’envoi.',
	
	'NO_EMAIL_MESSAGE'		=> 'Tu dois saisir un message.',
	'NO_EMAIL_SUBJECT'		=> 'Tu dois spécifier le sujet de ton message.',
));

?>