--TEST--
Tests maxdb_query()
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
$tc = "maxdb_query_001";
$link = maxdb_connect("localhost");
maxdb_report (MAXDB_REPORT_OFF);
maxdb_query($link,"DROP TABLE maxdb_query_001");
maxdb_report (MAXDB_REPORT_ERROR);

$cmds = array (
         "create table ".$tc." ("
        ."  C_CHARASCII    Char (1) ASCII NOT NULL,"
        ."  C_CHARBYTE     Char (1) BYTE,"
        ."  C_VARCHARASCII  Varchar (1) ASCII,"
        ."  C_VARCHARBYTE   Varchar (1) BYTE,"
        ."  C_INT          Integer,"
        ."  C_SMALINT      Smallint,"
        ."  C_FLOAT        Float (5),"
        ."  C_FIXED        Fixed (5),"
        ."  C_FIXED1       Fixed (5,5),"
        ."  C_BOOLEAN      Boolean,"
        ."  C_DATE         Date,"
        ."  C_TIME         Time,"
        ."  C_TIMESTAMP    Timestamp,"
        ."  C_LONGASCII    Long ASCII,"
        ."  C_LONGBYTE     Long BYTE"
        .")",
        
         "insert into ".$tc." values ( "
        ." 'A',"
        ."  x'41',"
        ."  'B',"
        ."  x'42',"
        ."  42,"
        ."  42,"
        ."  42.42,"
        ."  42,"
        ."  0.12345,"
        ."  TRUE,"
        ."  '1973-06-07',"
        ."  '14:30:08',"
        ."  '1999-01-23 14:30:08.456234',"
        ."  'ABCDEFGHIJKLMNOPQRSTUVWXYZ',"
        ."  null"
        .")"
       );   

foreach($cmds as $cmd){   
  maxdb_query($link, $cmd);
}
maxdb_commit($link);
$cmd = "Select * from ".$tc;
$stmt = maxdb_prepare ($link, $cmd);
maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11, $c12,
		  $c13, $c14, $c15);	
maxdb_execute($stmt);
maxdb_fetch($stmt);
$test = array ($c1, $c2, $c3, $c4, $c5, $c6, $c7, $c8, $c9, $c10, $c11, $c12,
		  $c13, $c14, $c15);
var_dump($test);

maxdb_close($link);

?>
--EXPECT--
array(15) {
  [0]=>
  string(1) "A"
  [1]=>
  string(1) "A"
  [2]=>
  string(1) "B"
  [3]=>
  string(1) "B"
  [4]=>
  int(42)
  [5]=>
  int(42)
  [6]=>
  float(42.42)
  [7]=>
  int(42)
  [8]=>
  float(0.12345)
  [9]=>
  bool(true)
  [10]=>
  string(10) "1973-06-07"
  [11]=>
  string(8) "14:30:08"
  [12]=>
  string(26) "1999-01-23 14:30:08.456234"
  [13]=>
  string(26) "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
  [14]=>
  NULL
}

