<?php

abstract class peartheme extends PhDThemeXhtml {
    protected $elementmap = array(
        'acronym'               => 'span',
        'article'               => 'format_container_chunk',
        'answer'                => 'format_answer',
        'appendix'              => 'format_container_chunk',
        'author'                => array(
            /* DEFAULT */          'format_editedby',
            'authorgroup'       => 'format_suppressed_tags',
        ),
        'authorgroup'           => 'format_editedby',
        'bibliography'          => array(
            /* DEFAULT */          false,
            'article'           => 'format_chunk',
            'book'              => 'format_chunk',
            'part'              => 'format_chunk',
        ),
        'book'                  => 'format_root_chunk',
        'callout'               => 'format_callout',
        'calloutlist'           => 'format_calloutlist',
        'copyright'             => 'format_copyright',
        'coref'                 => 'format_suppressed_tags',
        'chapter'               => 'format_container_chunk',
        'classname'             => 'strong',
        'colophon'              => 'format_chunk',
        'constant'              => 'strong',
        'emphasis'              => 'format_emphasis',
        'filename'              => array(
            /* DEFAULT */          'tt',
            'titleabbrev'       => 'format_suppressed_tags',
        ),
        'firstname'             => 'format_suppressed_tags',
        'funcdef'               => 'format_funcdef',
        'funcprototype'         => 'format_funcprototype',

        'funcsynopsisinfo'      => 'format_programlisting',
        'funcsynopsis'          => 'format_div',
        'function'              => 'strong',
        'editor'                => 'format_div',
        'email'                 => 'tt',
        'glossary'              => array(
            /* DEFAULT */          false,
            'article'           => 'format_chunk',
            'book'              => 'format_chunk',
            'part'              => 'format_chunk',
        ),
        'glossentry'            => 'format_suppressed_tags',
        'glossdef'              => 'format_glossdef',
        'glosslist'             => 'format_dl',
        'glossterm'             => 'format_glossterm',
        'guimenu'               => 'format_guimenu',
        'holder'                => 'format_holder',
        'imagedata'             => 'format_imagedata',
        'important'             => 'format_admonition',
        'info'                  => array(
            /* DEFAULT */          false,
//             'chapter'           => 'format_comment',
            'refsynopsisdiv'    => 'format_comment',
            'warning'           => 'format_suppressed_tags',
        ),
        'index'                 => array(
            /* DEFAULT */          false,
            'article'           => 'format_chunk',
            'book'              => 'format_chunk',
            'part'              => 'format_chunk',
        ),
        'informalexample'       => 'format_div',
        'informaltable'         => array(
            /* DEFAULT */          'format_table',
            'para'              => 'format_para_informaltable',
        ),
        'legalnotice'           => 'format_chunk',
        'link'					=> 'format_link',
        'listitem'              => array(
            /* DEFAULT */          false,
            'varlistentry'      => 'dd',
            'itemizedlist'      => 'li',
        ),
        'literal'               => 'tt',
        'literallayout'         => 'format_literallayout',
        'menuchoice'            => 'format_suppressed_tags',
        'methodname'            => 'tt',
        'note'                  => 'format_admonition',
        'package'               => 'strong',
        'para'                  => array(
            /* DEFAULT */          false,
            'question'          => 'span',//can't ignore it since it's defined in format
            'warning'           => 'format_warning_para',
            'important'         => 'format_suppressed_tags',
        ),
        'paramdef'              => 'format_paramdef',
        'parameter'             => array(
            /* DEFAULT */          false,
            'paramdef'           => 'format_suppressed_tags',
        ),
        'part'                  => 'format_container_chunk',
        'phd:pearapi'           => 'format_phd_pearapi',
        'preface'               => 'format_container_chunk',
        'programlisting'        => 'format_programlisting',
        'prompt'                => 'tt',
        'pubdate'               => 'p',
        'qandaentry'            => 'format_qandaentry',
        'qandaset'              => 'format_qandaset',
        'question'              => 'format_question',
        'replaceable'           => 'format_replaceable',
        'refentry'              => 'format_chunk',
        'reference'             => 'format_container_chunk',
        'phd:toc'               => 'format_phd_toc',
        'phpdoc:exception'      => 'format_exception_chunk',
        'refname'               => 'h1',
        'refnamediv'            => 'format_suppressed_tags',
        'refpurpose'            => 'format_refpurpose',
        'refsection'            => 'format_container_chunk',
        'refsynopsisdiv'        => 'format_refsynopsisdiv',
        'screen'                => 'format_screen',
        'sect1'                 => 'format_chunk',
        'sect2'                 => 'format_chunk',
        'sect3'                 => 'format_chunk',
        'sect4'                 => 'format_chunk',
        'sect5'                 => 'format_chunk',
        'section'               => 'format_container_chunk',
        'set'                   => 'format_root_chunk',
        'setindex'              => 'format_chunk',
        'simpara'               => array(
            /* DEFAULT */          false,
            'entry'             => 'p',
            'listitem'          => 'p',
            'warning'           => 'format_warning_para',
        ),
        'subtitle'              => 'format_subtitle',
        'surname'               => 'format_surname',
        'synopsis'              => 'format_programlisting',
        'table'                 => 'format_table',
        'title'                 => array(
            /* DEFAULT */          false,
            'article'           => 'format_container_chunk_title',
            'appendix'          => 'format_container_chunk_title',
            'chapter'           => 'format_container_chunk_title',
            //'example'           => 'format_example_title',
            'part'              => 'format_container_chunk_title',
            'preface'           => 'format_container_chunk_title',
            'info'              => array(
                /* DEFAULT */      false,
                'article'       => 'format_container_chunk_title',
                'appendix'      => 'format_container_chunk_title',
                'chapter'       => 'format_container_chunk_title',
                //'example'       => 'format_example_title',
                'informaltable' => 'format_table_title',
                'part'          => 'format_container_chunk_title',
                'refsection'    => 'format_container_chunk_title',
                'section'       => array(
                    /* DEFAULT */  'format_container_chunk_title',
                    'section'   => array(
                                   'h2',
                      'section' => array(
                                   'h3',
                       'section'=> array(
                                   'h4',
                       'section'=> 'h5'
                       ),
                      ),
                    ),
                ),
                'table'         => 'format_table_title',
                'warning'       => 'format_warning_title',
            ),
            'refsect1'          => 'h2',
            'refsect2'          => 'h3',
            'refsect3'          => 'h4',
            'section'           => array(
                /* DEFAULT */      'format_container_chunk_title',
                'section'       => array(
                    /* DEFAULT */  'h2',
                    'section'   => array(
                     /* DEFAULT */ 'h3',
                     'section'  => array(
                      /* DEFAULT */'h4',
                      'section' => 'h5'
                     ),
                    ),
                ),
            ),
            'table'             => 'format_table_title',
            'warning'           => 'format_warning_title',
        ),
        'tbody'                 => 'tbody',
        'term'                  => 'dt',
        'userinput'             => 'format_userinput',
        'variablelist'          => 'format_div',
        'varlistentry'          => 'format_dl',
        'varname'               => 'tt',
        'warning'               => 'format_warning',
        'xref'                  => 'format_link',
    );

    protected $textmap =        array(
        'classname'             => array(
            /* DEFAULT */          false,
            'refname'           => 'format_refname_classname_text',
        ),
        'filename'              => array(
            /* DEFAULT */          false,
            'titleabbrev'       => 'format_suppressed_text',
        ),
        'function'              => array(
            /* DEFAULT */          'format_function_text',
            'funcdef'           => false,
            'refname'           => 'format_refname_function_text',
        ),
        'phd:pearapi'           => 'format_phd_pearapi_text',
        'programlisting'        => 'format_programlisting_text',
        'refname'               => 'format_refname_text',
        'year'                  => 'format_year',
    );

    /**
    * Programlisting role/type (php, xml, ..).
    * Necessary to highlight the code properly.
    * String when role is set, false if not.
    *
    * @var string
    *
    * @see format_programlisting()
    * @see CDATA()
    */
    public $role    = false;

    /**
    * File extension string
    * e.g. ".php" or ".htm"
    *
    * @var string
    */
    public $ext     = null;

    /**
    * If whitespace should be trimmed.
    * Helpful for programlistings that are encapsulated in <pre> tags
    *
    * @var boolean
    *
    * @see CDATA()
    */
    public $trim    = false;

    /**
    * URL prefix for all API doc link generated with <phd:pearapi>
    *
    * @var string
    */
    public $phd_pearapi_urlprefix = 'http://pear.php.net/package/';

    /**
    * Name of the ID currently being processed
    *
    * @var string
    */
    protected $CURRENT_ID = "";

    /* Current Chunk settings */
    protected $cchunk          = array();
    /* Default Chunk settings */
    protected $dchunk          = array(
        'fieldsynopsis'                => array(
            'modifier'                          => 'public',
        ),
        'container_chunk'              => null,
        'qandaentry'                   => array(
        ),
        'examples'                     => 0,
        'verinfo'                      => false,
        'refname'                      => array(),
    );

    /**
     * Constructor
     *
     * @param array  $IDs     Array of elements
     * @param string $ext     Filename extension to use
     * @param bool   $chunked whether or not to chunk the output
     */
    public function __construct(array $IDs, $ext = 'php', $chunked = true)
    {
        parent::__construct($IDs, $ext);
        $this->ext = $ext;
        $this->chunked = $chunked;
    }

    /**
    * Clean up HTML from empty paragraph tags (<p>).
    *
    * @param string $str String to clean up
    *
    * @return string Cleaned up string.
    */
    protected function cleanHtml($str)
    {
        return preg_replace('#<p>\\s*</p>#s', '', $str);
    }

    public function format_chunk($open, $name, $attrs, $props)
    {
        $id = null;
        if (isset($attrs[PhDReader::XMLNS_XML]['id'])) {
            $this->CURRENT_ID = $id = $attrs[PhDReader::XMLNS_XML]['id'];
        }
        if ($props['isChunk']) {
            $this->cchunk = $this->dchunk;
        }
        if (isset($props['lang'])) {
            $this->lang = $props['lang'];
        }
        if ($name == 'refentry') {
            if (isset($attrs[PhDReader::XMLNS_DOCBOOK]['role'])) {
                $this->cchunk['verinfo'] = !($attrs[PhDReader::XMLNS_DOCBOOK]['role'] == 'noversion');
            } else {
                $this->cchunk['verinfo'] = true;
            }
        }
        if ($name == 'legalnotice') {
            if ($open) {
                return '<div class="' . $name . '" ' . ($id ? "id=\"{$id}\"" : '') . '">';
            }
            return "</div>\n";
        }
        return false;
    }

    public function format_container_chunk($open, $name, $attrs, $props)
    {
        if (!isset($attrs[PhDReader::XMLNS_XML]['id'])) {
            if ($open) {
                return "<div class=\"{$name}\">";
            } else {
                return "</div>\n";
            }
        }
        $this->CURRENT_ID = $id = $attrs[PhDReader::XMLNS_XML]['id'];

        if (!$open) {
            return "</div>\n";
        }

        if ($props['isChunk']) {
            $this->cchunk = $this->dchunk;
        }

        $toc = $this->createToc(
            $id, $name, $props,
            isset($attrs[PhDReader::XMLNS_PHD]['toc-depth'])
                ? (int)$attrs[PhDReader::XMLNS_PHD]['toc-depth'] : 1
        );
        if ($toc) {
            $toc = "<div class=\"TOC\">\n" . $toc . "</div>\n";
        }
        $this->cchunk['container_chunk'] = $toc;

        return "<div class=\"{$name}\" id=\"{$id}\">";
    }

    public function format_div($open, $name, $attrs, $props)
    {
        return $this->format->format_div($open, $name, $attrs, $props);
    }

    public function format_exception_chunk($open, $name, $attrs, $props)
    {
        return $this->format_container_chunk($open, 'reference', $attrs, $props);
    }

    /**
     * Formatting for the root element of a chunk.
     *
     * @param bool   $open  Whether we should open or close this element.
     * @param string $name  Name of the element
     * @param array  $attrs Attributes present for the element. Array keys are the attribute namespaces.
     * @param array  $props Associative array of additional properties
     *
     * @return string
     */
    public function format_root_chunk($open, $name, $attrs, $props)
    {
        $this->CURRENT_ID = $id = $attrs[PhDReader::XMLNS_XML]['id'];
        if ($open) {
            return "<div class=\"{$name}\">";
        }

        $content = $this->createToc(
            $id, $name, $props,
            isset($attrs[PhDReader::XMLNS_PHD]['toc-depth'])
                ? (int)$attrs[PhDReader::XMLNS_PHD]['toc-depth'] : 1
        );

        $content .= "</div>\n";

        return $content;
    }

    /**
     * Format a link for an element
     *
     * @param bool   $open  If the link should be opened.
     * @param string $name  Name of the element.
     * @param array  $attrs Attributes present for the element. Array keys are the attribute namespaces.
     * @param array  $props Properties
     *
     * @return string
     */
    public function format_link($open, $name, $attrs, $props)
    {
        if ($open) {
            $content = $fragment = '';
            $class = $name;

            if (isset($attrs[PhDReader::XMLNS_DOCBOOK]['linkend'])) {
                $linkto = $attrs[PhDReader::XMLNS_DOCBOOK]['linkend'];
                $id = $href = PhDHelper::getFilename($linkto);

                if ($id != $linkto) {
                    $fragment = "#$linkto";
                }
                if ($this->chunked) {
                    $href .= '.'.$this->ext;
                }
            } elseif (isset($attrs[PhDReader::XMLNS_XLINK]['href'])) {
                $href = $attrs[PhDReader::XMLNS_XLINK]['href'];
                $class .= ' external';
            }
            if ($name == 'xref') {
                if ($this->chunked) {
                    $link = $href;
                } else {
                    $link = '#';
                    if (isset($linkto)) {
                        $link .= $linkto;
                    } else {
                        $link .= $href;
                    }
                }
                return '<a href="' . htmlspecialchars($link). '" class="' .$class. '">' .($content.PhDHelper::getDescription($id, false)). '</a>';
            } elseif ($props['empty']) {
                if ($this->chunked) {
                    $link = '';
                } else {
                    $link = '#';
                }
                return '<a href="' .$link.$href.$fragment. '" class="' .$class. '">' .$content.$href.$fragment. '</a>';
            } else {
                if ($this->chunked) {
                    $link = $href.$fragment;
                } elseif (isset($linkto)) {
                    if ($fragment) {
                        $link = $fragment;
                    } else {
                        $link = "#$href";
                    }
                } else {
                    $link = $href;
                }
                return '<a href="' .htmlspecialchars($link). '" class="' .$class. '">' .$content;
            }
        }
        return '</a>';
    }

    public function format_container_chunk_title($open, $name, $attrs, $props)
    {
        if ($open) {
            return $props["empty"] ? '' : '<h1>';
        }
        $ret = '';
        if (isset($this->cchunk['container_chunk']) && $this->cchunk['container_chunk']) {
            $ret = $this->cchunk['container_chunk'];
            $this->cchunk['container_chunk'] = null;
        }
        return "</h1>\n" .$ret;
    }

    public function transformFromMap($open, $tag, $name, $attrs, $props)
    {
        if ($open) {
            $idstr = '';
            if (isset($attrs[PhDReader::XMLNS_XML]['id'])) {
                $id = $attrs[PhDReader::XMLNS_XML]['id'];
                $idstr = ' id="' .$id. '" name="' .$id. '"';
            }
            return '<' .$tag. ' class="' .$name. '"' . $idstr. '>' . ($props['empty'] ? "</{$tag}>" : '');
        }
        return '</' .$tag. '>';
    }

    public function format_para_informaltable($open, $name, $attrs, $props)
    {
        if ($open) {
            return $this->format->escapePara()
                . $this->format_table($open, $name, $attrs, $props);
        }
        return $this->format_table($open, $name, $attrs, $props) . $this->format->restorePara();
    }

    /**
    * Creates a link to the PEAR API documentation.
    * Uses the tag text as well as the optional attributes package, class,
    * method and var.
    */
    public function format_phd_pearapi($open, $name, $attrs, $props)
    {
        if ($open && !$props['empty']) {
            return '';
        }

        $text      = $props['empty'] ? '' : $this->phd_pearapi_text;
        $package   = $attrs[PhDReader::XMLNS_PHD]['package'];
        $linkend   = isset($attrs[PhDReader::XMLNS_PHD]['linkend'])
                   ? $attrs[PhDReader::XMLNS_PHD]['linkend'] : null;
        $arLinkend = explode('::', $linkend);
        $class     = null;
        $method    = null;
        $variable  = null;

        if ($linkend === null) {
            //link to package
            if ($props['empty']) {
                $text    = $package;
            }
            $linktpl = '{$package}/docs/latest/li_{$package}.html';
        } else {
            $class = $arLinkend[0];
            if ($props['empty']) {
                $text = $linkend;
            }
            if (count($arLinkend) == 1) {
                //link to class
                $linktpl = '{$package}/docs/latest/{$package}/{$class}.html';
            } else if ($arLinkend[1]{0} == '$') {
                //link to class variable
                $variable = $arLinkend[1];
                $linktpl = '{$package}/docs/latest/{$package}/{$class}.html#var{$variable}';
            } else {
                //link to method
                if ($props['empty']) {
                    $text   .= '()';
                }
                $method  = $arLinkend[1];
                $linktpl = '{$package}/docs/latest/{$package}/{$class}.html#method{$method}';
            }
        }

        $uri = $this->phd_pearapi_urlprefix . str_replace(
            array('{$package}', '{$class}', '{$method}', '{$variable}'),
            array($package, $class, $method, $variable),
            $linktpl
        );

        return '<a href="' . htmlspecialchars($uri) . '"'
            . ' class="apidoclink">' . $text . '</a>';
    }

    public function format_phd_pearapi_text($value, $tag)
    {
        $this->phd_pearapi_text = $value;
    }

    /**
    * Format a &lt;programlisting&gt; tag.
    * Highlighting an such is done in format_programlisting_text()
    *
    * @param string $value Value of the text to format.
    * @param string $tag   Tag name
    * @param array  $attrs Array of attributes
    *
    * @return string Generated programlisting html
    */
    public function format_programlisting($open, $name, $attrs)
    {
        if ($open) {
            $this->trim = true;
            if (isset($attrs[PhDReader::XMLNS_DOCBOOK]['role'])) {
                $this->role = $attrs[PhDReader::XMLNS_DOCBOOK]['role'];
            } else {
                $this->role = '';
            }

            return $this->format->escapePara()
                . '<div class="'. ($this->role ? $this->role . 'code' : 'programlisting')
                . '" style="background-color:#EEE; width: 100%">';
        }
        $this->role = false;
        $this->trim = false;

        return '</div>' . $this->format->restorePara();
    }

    /**
    * Format the text within a program listing section.
    * Highlighting is done via the external highlighter.
    * programlisting without php tags get them appended
    *
    * @param string $value Value of the text to format.
    * @param string $tag   Tag name
    *
    * @return string Highlighted text.
    */
    public function format_programlisting_text($value, $tag)
    {
        switch($this->role) {
        case 'php':
            if (strrpos($value, '<?php') || strrpos($value, '?>')) {
                return $this->highlight(trim($value), 'php', 'xhtml');
            } else {
                return $this->highlight("<?php\n" . trim($value) . "\n?>", 'php', 'xhtml');
            }
            break;
        default:
            return $this->highlight(trim($value), $this->role, 'xhtml');
        }
    }

    public function format_screen($open, $name, $attrs)
    {
        if ($open) {
            return $this->format->escapePara()
                . '<pre class="screen" style="background-color:#EEE; width: 100%">';
        }
        return "</pre>\n" . $this->format->restorePara();
    }

    public function format_literallayout($open, $name, $attrs)
    {
        //FIXME: add support for attributes like class, continuation etc
        if ($open) {
            return $this->format->escapePara()
                . '<p class="literallayout">';
        }
        return "</p>\n" . $this->format->restorePara();
    }

    /**
    * Format a CDATA section. Automatically trims and highlights
    * the text when necessary.
    *
    * @param string $str CDATA content
    *
    * @return string Formatted string
    *
    * @see $trim
    * @see $role
    */
    public function CDATA($str)
    {
        if ($this->trim) {
            $str = rtrim($str);
        }
        if (!$this->role) {
            return str_replace(
                array("\n", ' '), array('<br/>', '&nbsp;'),
                htmlspecialchars($str, ENT_QUOTES, 'UTF-8')
            );
        }

        switch ($this->role) {
        case 'php':
            if (strrpos($str, '<?php') || strrpos($str, '?>')) {
                $str = $this->highlight(trim($str), $this->role, 'xhtml');
            } else {
                $str = $this->highlight("<?php\n" . trim($str) . "\n?>", $this->role, 'xhtml');
            }
            break;
        case '':
            $str = htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
            break;
        default:
            $str = $this->highlight($str, $this->role, 'xhtml');
            break;
        }

        return $str;
    }

    public function format_suppressed_tags($open, $name, $attrs)
    {
        /* Ignore it */
        return '';
    }

    public function format_suppressed_text($value, $tag)
    {
        /* Suppress any content */
        return '';
    }

    public function format_surname($open, $name, $attrs)
    {
        /* Add a space before it, so firstname and surname are separated */
        return ' ';
    }

    public function format_subtitle($open, $name, $attrs)
    {
        if ($open)
            return '<p><font color="red">';
        return '</font></p>';
    }

    public function format_editedby($open, $name, $attrs, $props)
    {
        if ($open) {
            return '<h2 class="EDITEDBY">' . $this->autogen('editedby', $props['lang']) . '</h2>';
        }

    }

    public function format_copyright($open, $name, $attrs)
    {
        if ($open) {
            if ($this->chunked) {
                return '<p class="'.$name.'"><a href="copyright.' . $this->ext . '">Copyright</a> &copy; ';
            } else {
                return '<p class="'.$name.'"><a href="#copyright">Copyright</a> &copy; ';
            }
        }
        return '</p>';
    }

    public function format_comment($open, $name, $attrs)
    {
        if ($open) {
            return '<!-- ';
        }
        return '-->';
    }

    public function format_holder($open, $name, $attrs, $props)
    {
        if ($open)
            return $this->autogen('by', $props['lang']) . " ";
    }

    public function format_year($value)
    {
        return $value . ', ';
    }

    public function format_admonition($open, $name, $attrs, $props)
    {
        if ($open) {
            return $this->format->escapePara()
                . '<blockquote class="' . $name . '"><strong>'.$this->autogen($name, $props['lang']). ': </strong>';
        }
        return "</blockquote>\n" . $this->format->restorePara();
    }

    public function format_table($open, $name, $attrs, $props)
    {
        if ($open) {
            return $this->format->escapePara() . '<table border="1" class="'.$name.'">';
        }
        return "</table>\n" . $this->format->restorePara();
    }

    public function format_entry($open, $name, $attrs, $props)
    {
        if ($open) {
            if ($props['empty']) {
                return '<td></td>';
            }
            return '<td>';
        }
        return '</td>';
    }

    public function format_th_entry($open, $name, $attrs)
    {
        if ($open) {
            $colspan = PhDFormat::colspan($attrs[PhDReader::XMLNS_DOCBOOK]);
            return '<th colspan="' .((int)$colspan). '">';
        }
        return '</th>';
    }

    public function format_table_title($open, $name, $attrs, $props)
    {
        if ($props['empty'])
            return '';
        if ($open) {
            return '<caption><strong>';
        }
        return '</strong></caption>';
    }

    public function format_userinput($open, $name, $attrs, $props)
    {
        if ($open) {
            return '<tt class="'.$name.'"><strong>';
        }
        return '</strong></tt>';
    }

    public function format_replaceable($open, $name, $attrs, $props)
    {
        if ($open) {
            return '<tt class="'.$name.'"><em>';
        }
        return '</em></tt>';
    }

    public function format_warning($open, $name, $attrs, $props)
    {
        if ($open) {
            return $this->format->escapePara()
                . '<div class="warning" style="border: 3px double black; padding: 5px">' . "\n";
        }
        return "</div>\n" . $this->format->restorePara();
    }

    public function format_warning_title($open, $name, $attrs, $props)
    {
        if ($open) {
            return '<strong class="warning_title" style="display:block; text-align: center; width:100%">';
        }
        return "</strong>\n";
    }

    public function format_warning_para($open, $name, $attrs, $props)
    {
        if ($open) {
            if (!$props['sibling']) {
                return '<strong>' . $this->autogen('warning', $props['lang']) . "</strong>\n"
                    . '<p>';
            }
            return '<p>';
        }
        return "</p>\n";
    }

    public function format_refname_function_text($value)
    {
        $this->cchunk['refname'][] = '<b class="function">' . $this->format->TEXT($value . '()') . '</b>';
        return false;
    }

    public function format_refname_classname_text($value)
    {
        $this->cchunk['refname'][] = '<b class="classname">' . $this->format->TEXT($value) . '</b>';
        return false;
    }

    public function format_refpurpose($open, $tag, $attrs)
    {
        if ($open) {
            $refnames = implode(' ', $this->cchunk['refname']);
            return '<div class="refnamediv">'. $refnames. ' &ndash; ';
        }
        return "</div>\n";
    }

    public function format_refname_text($value, $tag)
    {
        $this->cchunk['refname'][] = $this->format->TEXT($value);
        return false;
    }

    public function format_function_text($value)
    {
        return $this->format->TEXT($value.'()');
    }

    public function format_paramdef($open, $name, $attrs, $props)
    {
        if ($open && $props['sibling'] == 'paramdef') {
            return ' , ';
        }
        return false;
    }

    public function format_funcdef($open, $name, $attrs, $props)
    {
        if (!$open) {
            return ' ( ';
        }
        return false;
    }

    public function format_funcprototype($open, $name, $attrs, $props)
    {
        if ($open) {
            return '<p><code class="' . $name . '">';
        }
        return ')</code></p>';
    }

    public function format_refsynopsisdiv($open, $name, $attrs, $props)
    {
        if ($open) {
            return '<h2 class="refsynopsisdiv">Synopsis</h2>';
        }
        return '';
    }

    public function format_guimenu($open, $name, $attrs, $props)
    {
        if ($open) {
            if ($props['sibling'])
                return '-&gt;<span class="guimenu"><i>';
            return '<span class="guimenu"><i>';
        }
        return '</i></span>';
    }

    public function format_dl($open, $name, $attrs, $props)
    {
        return $this->format->format_dl($open, $name, $attrs, $props);
    }

    /**
     * FIXME: This function is a crazy performance killer
     *
     * @param resource $stream Stream containing the contents of a Q&A section
     *
     * @return string
     */
    public function qandaset($stream)
    {
        $xml = stream_get_contents($stream);

        $old = libxml_use_internal_errors(true);
        $doc = new DOMDocument('1.0', 'UTF-8');
        $doc->preserveWhitespace = false;
        $doc->loadXML(html_entity_decode(str_replace('&', '&amp;amp;', "<div>$xml</div>"), ENT_QUOTES, 'UTF-8'));
        if ($err = libxml_get_errors()) {
            echo 'qandaset xml problem in ' . $this->CURRENT_ID . "\n";
            print_r($err);
            libxml_clear_errors();
        }
        fclose($stream);
        libxml_use_internal_errors($old);

        $xpath = new DOMXPath($doc);
        $nlist = $xpath->query('//div/dl/dt/strong');
        $ret = '<div class="qandaset"><ol class="qandaset_questions">';
        $i = 0;
        foreach ($nlist as $node) {
            $ret .= '<li><a href="#' .($this->cchunk['qandaentry'][$i++]). '">' .($node->textContent). '</a></li>';
        }

        return $ret.'</ol>'.$xml.'</div>';
    }

    public function format_qandaentry($open, $name, $attrs)
    {
        if ($open) {
            $this->cchunk['qandaentry'][] = $this->CURRENT_ID . '.entry' . count($this->cchunk['qandaentry']);
            return '<dl>';
        }
        return '</dl>';
    }

    public function format_answer($open, $name, $attrs)
    {
        if ($open) {
            return '<dd><a name="' .end($this->cchunk['qandaentry']).'"></a>';
        }
        return '</dd>';
    }

    public function format_question($open, $name, $attrs)
    {
        if ($open) {
            return '<dt><strong>';
        }
        return '</strong></dt>';
    }

    public function format_emphasis($open, $name, $attrs)
    {
        if (isset($attrs[PhDReader::XMLNS_DOCBOOK]['role']) && $attrs[PhDReader::XMLNS_DOCBOOK]['role'] == "bold")
            $role = "b";
        else $role = "i";
        if ($open) {
            return '<' . $role . ' class="' . $name . '">';
        }
        return "</{$role}>";
    }

    public function format_glossterm($open, $name, $attrs)
    {
        if ($open) {
            return '<dt><strong>';
        }
        return '</strong></dt>';
    }

    public function format_glossdef($open, $name, $attrs)
    {
        if ($open) {
            return '<dd><p>';
        }
        return '</p></dd>';
    }

    public function format_calloutlist($open, $name, $attrs)
    {
        if ($open) {
            $this->cchunk['callouts'] = 0;
            return $this->format->escapePara() . '<table>';
        }
        return '</table>' . $this->format->restorePara();
    }

    public function format_callout($open, $name, $attrs)
    {
        if ($open) {
            return '<tr><td><a href="#'.$attrs[PhDReader::XMLNS_DOCBOOK]['arearefs'].'">(' .++$this->cchunk['callouts']. ')</a></td><td>';
        }
        return "</td></tr>\n";
    }
}
