# $Progeny: stage1.sh,v 1.58 2002/04/23 21:49:57 branden Exp $

LD_LIBRARY_PATH=$LIVE/lib:/lib
PATH=$LIVE/sbin:$LIVE/bin:/sbin:/bin:/usr/bin:/usr/sbin
PYTHONHOME=$LIVE
TARGET=/target

export PYTHONHOME TARGET

# debconf-communiate is quite clearly a black box.  Why?  Because
# talking to it with a here document produces unpredictable behavior
# (I.e., "I've seen EOF on one file descriptor, I think I'll go open
# another one and read from it for a while now".)  Fun, fun.
debconf_poke () {
    package=$1
    shift
    pgilog "echo \"$@\" | chroot $TARGET debconf-communicate $package"
    echo "$@" | chroot $TARGET debconf-communicate $package;
}

unmount_targets () {
    if [ -s /etc/mtab ]; then
        fslist=$(awk '{ if (match($2, "/target.*")) print $2 } < /etc/mtab' | sort -r)
        if [ -n "$fslist" ]; then
            for fs in $fslist; do
                pgilog "Unmounting $fs."
                umount $fs
                sleep 1
            done
        fi
    fi;
}

shellspawn &
SHELLSPAWN_PID=$!

ident /sbin/stage0.sh                         >> $IDENTLOG 2> /dev/null
ident /sbin/configure-network                 >> $IDENTLOG 2> /dev/null
ident /bin/busybox                            >> $IDENTLOG 2> /dev/null
ident /bin/envsh                              >> $IDENTLOG 2> /dev/null

ident $LIVE/share/installer/*                 >> $IDENTLOG 2> /dev/null
ident $LIVE/bin/busybox                       >> $IDENTLOG 2> /dev/null
ident $LIVE/bin/list-devices                  >> $IDENTLOG 2> /dev/null
ident $LIVE/bin/xinitrc                       >> $IDENTLOG 2> /dev/null
ident $LIVE/sbin/shellspawn                   >> $IDENTLOG 2> /dev/null
ident $LIVE/lib/python2.1/site-packages/pgi/* >> $IDENTLOG 2> /dev/null

ident $LIVE/bin/debootstrap                   >> $IDENTLOG 2> /dev/null
ident $LIVE/lib/debootstrap/*                 >> $IDENTLOG 2> /dev/null
ident $LIVE/lib/debootstrap/scripts/*         >> $IDENTLOG 2> /dev/null

ident $LIVE/XF86Config.template               >> $IDENTLOG 2> /dev/null

MODULE_DIR=$(echo /lib/modules/*)
pgilog "Symlinking $MODULE_DIR to $LIVE/kernel$MODULE_DIR."
mv $MODULE_DIR $MODULE_DIR.backup
if [ ! -d $LIVE/kernel/$MODULE_DIR ]; then
    echo "ERROR: kernel modules on live filesystem do not match running kernel."
    echo "Cannot continue with installation."
    echo -n "Restart system? (yes/no) [yes is default] "
    read input
    case "$input" in
    n*)
        echo "When this shell exits, the PGI Debian installer will restart the system."
        envsh
        ;;
    *)
        ;;
    esac
    initrd-reboot
fi
ln -s $LIVE/kernel/$MODULE_DIR $MODULE_DIR

# XXX: discover/modprobe ide-disk sd_mod and search for scsi devices
SCSI_MODULES=$(discover --disable-all --enable=pci,usb,ide,scsi --module scsi)
for MODULE in ide-disk sd_mod $SCSI_MODULES; do
    modprobe $MODULE 2> /dev/null
done

if [ -n "$PGIDEBUG" ]; then
    echo "Preparing to run \"$LIVE/share/installer/preinst.sh\"; launching shell."
    envsh
fi

# pre-installation vendor-hook
if [ -f $LIVE/share/installer/preinst.sh ]; then
    . $LIVE/share/installer/preinst.sh
fi

# run the installer
if [ -n "$TEXTMODE" ]; then
    . $LIVE/share/installer/installer-text.sh
else
    . $LIVE/share/installer/installer-x.sh
    if [ -n "$TEXTMODE_FALLBACK" ]; then
        . $LIVE/share/installer/installer-text.sh
    fi
fi

if [ -n "$CANCEL" ]; then
    pgilog "User cancelled installation."
else
    ###########################################################################
    # store network settings for stage 2, if we have any

    if [ -f /etc/network/interfaces ]; then
        # Since we're not rebooting, set a hostname
        hostname $(cat /etc/hostname)

        # Copy files
        cp /etc/hostname $TARGET/etc
        cp /etc/hostname $TARGET/etc/mailname
        cp /etc/hosts $TARGET/etc
        cp /etc/network/interfaces $TARGET/etc/network
        if [ -f /etc/resolv.conf ]; then
            cp /etc/resolv.conf $TARGET/etc
        fi

        # Setup etherconf
        echo -n "Writing network configuration to installed system..."
        pgilog -n "Loading $LIVE/share/debconf/etherconf.templates..."
        cp $LIVE/share/debconf/etherconf.templates $TARGET/tmp/etherconf.templates
        chroot $TARGET debconf-loadtemplate etherconf /tmp/etherconf.templates
        pgilog "done."
        pgilog -n "debconf-communicating for etherconf..."
        debconf_poke etherconf "register etherconf/configure etherconf/configure:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "register etherconf/removable etherconf/removable:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "register etherconf/dhcp-p etherconf/dhcp-p:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "register etherconf/dhcphost etherconf/dhcphost:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "register etherconf/ipaddr etherconf/ipaddr:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "register etherconf/netmask etherconf/netmask:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "register etherconf/gateway etherconf/gateway:eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "set etherconf/replace-existing-files true" 2>&1 >> $LOGFILE
        debconf_poke etherconf "fset etherconf/replace-existing-files seen true" 2>&1 >> $LOGFILE
        debconf_poke etherconf "set etherconf/INT-devices eth0" 2>&1 >> $LOGFILE
        debconf_poke etherconf "fset etherconf/INT-devices seen true" 2>&1 >> $LOGFILE
        debconf_poke etherconf "set etherconf/hostname debian" 2>&1 >> $LOGFILE
        debconf_poke etherconf "fset etherconf/hostname seen true" 2>&1 >> $LOGFILE
        debconf_poke etherconf "set etherconf/domainname $domain" 2>&1 >> $LOGFILE
        debconf_poke etherconf "fset etherconf/domainname seen true" 2>&1 >> $LOGFILE

        if grep -q dhcp /etc/network/interfaces; then
            debconf_poke etherconf "set etherconf/dhcp-p:eth0 true" 2>&1 >> $LOGFILE
            debconf_poke etherconf "fset etherconf/dhcp-p:eth0 seen true" 2>&1 >> $LOGFILE
            debconf_poke etherconf "set etherconf/dhcphost \"\"" 2>&1 >> $LOGFILE
            debconf_poke etherconf "fset etherconf/dhcphost seen true" 2>&1 >> $LOGFILE
        else
            debconf_poke etherconf "set etherconf/ipaddr:eth0 $ip" 2>&1 >> $LOGFILE
            debconf_poke etherconf "fset etherconf/ipaddr:eth0 seen true" 2>&1 >> $LOGFILE
            debconf_poke etherconf "set etherconf/netmask:eth0 $subnet" 2>&1 >> $LOGFILE
            debconf_poke etherconf "fset etherconf/netmask:eth0 seen true" 2>&1 >> $LOGFILE
            debconf_poke etherconf "set etherconf/gateway:eth0 gateway $router" 2>&1 >> $LOGFILE
            debconf_poke etherconf "fset etherconf/gateway:eth0 seen true" 2>&1 >> $LOGFILE
            debconf_poke etherconf "set etherconf/nameservers $dns" 2>&1 >> $LOGFILE
            debconf_poke etherconf "fset etherconf/nameservers seen true" 2>&1 >> $LOGFILE
        fi
        pgilog "done."
        echo "done."
        rm $TARGET/tmp/etherconf.templates
    fi

    if [ -n "$PGIDEBUG" ]; then
        echo "Preparing to run \"$LIVE/share/installer/postinst.sh\"; launching shell."
        envsh
    fi

    # post-installation vendor-hook
    if [ -f $LIVE/share/installer/postinst.sh ]; then
        pgilog "Calling post-installation vendor hook..."
        . $LIVE/share/installer/postinst.sh
        pgilog "Post-installation vendor hook completed."
    fi

    pgilog "Scanning target mount points..."
    pgilog "$(awk '/target/ { print $2, $1, $3 }' /proc/mounts)"
    pgilog "done scanning target mount points."

    pgilog "Calling finalization script..."
    python $LIVE/share/installer/setup-finalize-text.py --target $TARGET \
        $MNTPNTS | tee -a $LOGFILE
    pgilog "done with finalization script."
fi

# if doing noisy debugging, turn set -x back on; the installer scripts had to
# turn it off because it interferes with the dialog command
if [ -n "$NOISY" ]; then
    set -x
fi

# This hopefully explains the job control output that will follow.
echo "Terminating shells on alternate virtual consoles."
kill $SHELLSPAWN_PID

while [ -d /proc/$SHELLSPAWN_PID ]; do
    pgilog "Waiting for shellspawn ($SHELLSPAWN_PID) to die."
    sleep 1
done

pgilog "Restoring initrd's $MODULE_DIR."
rm -f $MODULE_DIR
mv $MODULE_DIR.backup $MODULE_DIR

# vim:ai:et:sts=4:sw=4:tw=0:
