#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: pointFunction.c,v 1.19 2000/10/17 13:48:57 knepley Exp $";
#endif

/*
     Defines the interface to the point functions
*/

#include "pointFunction.h"    /*I "mesh.h" I*/

#undef  __FUNCT__
#define __FUNCT__ "PointFunctionOne"
/*@
  PointFunctionOne - A PointFunction that is one at all locations.

  Input Parameters:
+ n      - number of points
. comp   - number of components
. x,y,z  - coordinates of points
- dummy  - unneeded context variable

   Output Parameter:
. values - location where 1.0 is stored (n*comp times)

  Level: beginner

.keywords point function
.seealso PointFunctionZero(), PointFunctionConstant()
@*/
int PointFunctionOne(int n, int comp, double *x, double *y, double *z, PetscScalar *values, void *dummy)
{
  int i;
  
  PetscFunctionBegin;
  for(i = 0; i < n*comp; i++) values[i] = 1.0;
  PetscFunctionReturn(0);
}

#undef  __FUNCT__
#define __FUNCT__ "PointFunctionZero"
/*@
  PointFunctionZero - A PointFunction that is zero at all locations.

  Input Parameters:
+ n      - number of points
. comp   - number of components
. x,y,z  - coordinates of points
- dummy  - unneeded context variable

  Output Parameter:
. values - location where 0.0 is stored (n*comp times)

  Level: beginner

.keywords point function
.seealso PointFunctionOne(), PointFunctionConstant()
@*/
int PointFunctionZero(int n, int comp, double *x, double *y, double *z, PetscScalar *values, void *dummy)
{
  int ierr;

  PetscFunctionBegin;
  ierr = PetscMemzero(values, n*comp * sizeof(PetscScalar));                                              CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef  __FUNCT__
#define __FUNCT__ "PointFunctionConstant"
/*@
  PointFunctionConstant - A PointFunction that is a constant at all locations. The constant itself
  is a real number pointed to by $ctx$.

  Input Parameters:
+ n      - The number of points
. comp   - The number of components
. x,y,z  - The coordinates of points
- ctx    - The constant

  Output Parameter:
. values - The location where the constant is stored (n*comp times)

  Level: beginner

.keywords point function
.seealso PointFunctionOne, PointFunctionZero
@*/
int PointFunctionConstant(int n, int comp, double *x, double *y, double *z, PetscScalar *values, void *ctx)
{
  double c = *(double *) ctx;
  int    i;

  PetscFunctionBegin;
  for(i = 0; i < n*comp; i++) values[i] = c;
  PetscFunctionReturn(0);
}
