/* mesh.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "mesh.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetup_ PMESHSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetup_ pmeshsetup
#else
#define meshsetup_ pmeshsetup_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetup_ MESHSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetup_ meshsetup
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetfromoptions_ PMESHSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetfromoptions_ pmeshsetfromoptions
#else
#define meshsetfromoptions_ pmeshsetfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetfromoptions_ MESHSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetfromoptions_ meshsetfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshviewfromoptions_ PMESHVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshviewfromoptions_ pmeshviewfromoptions
#else
#define meshviewfromoptions_ pmeshviewfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshviewfromoptions_ MESHVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshviewfromoptions_ meshviewfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshview_ PMESHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshview_ pmeshview
#else
#define meshview_ pmeshview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshview_ MESHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshview_ meshview
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshcopy_ PMESHCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshcopy_ pmeshcopy
#else
#define meshcopy_ pmeshcopy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshcopy_ MESHCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshcopy_ meshcopy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshduplicate_ PMESHDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshduplicate_ pmeshduplicate
#else
#define meshduplicate_ pmeshduplicate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshduplicate_ MESHDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshduplicate_ meshduplicate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshdestroy_ PMESHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshdestroy_ pmeshdestroy
#else
#define meshdestroy_ pmeshdestroy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshdestroy_ MESHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshdestroy_ meshdestroy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetusercontext_ PMESHSETUSERCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetusercontext_ pmeshsetusercontext
#else
#define meshsetusercontext_ pmeshsetusercontext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetusercontext_ MESHSETUSERCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetusercontext_ meshsetusercontext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetusercontext_ PMESHGETUSERCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetusercontext_ pmeshgetusercontext
#else
#define meshgetusercontext_ pmeshgetusercontext_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetusercontext_ MESHGETUSERCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetusercontext_ meshgetusercontext
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetoptionsprefix_ PMESHGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetoptionsprefix_ pmeshgetoptionsprefix
#else
#define meshgetoptionsprefix_ pmeshgetoptionsprefix_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshgetoptionsprefix_ MESHGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshgetoptionsprefix_ meshgetoptionsprefix
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshprinthelp_ PMESHPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshprinthelp_ pmeshprinthelp
#else
#define meshprinthelp_ pmeshprinthelp_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshprinthelp_ MESHPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshprinthelp_ meshprinthelp
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshcheckboundary_ PMESHCHECKBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshcheckboundary_ pmeshcheckboundary
#else
#define meshcheckboundary_ pmeshcheckboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshcheckboundary_ MESHCHECKBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshcheckboundary_ meshcheckboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetboundary_ PMESHSETBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetboundary_ pmeshsetboundary
#else
#define meshsetboundary_ pmeshsetboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetboundary_ MESHSETBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetboundary_ meshsetboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetreformboundary_ PMESHSETREFORMBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetreformboundary_ pmeshsetreformboundary
#else
#define meshsetreformboundary_ pmeshsetreformboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsetreformboundary_ MESHSETREFORMBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsetreformboundary_ meshsetreformboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshpartition_ PMESHPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshpartition_ pmeshpartition
#else
#define meshpartition_ pmeshpartition_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshpartition_ MESHPARTITION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshpartition_ meshpartition
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshcoarsen_ PMESHCOARSEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshcoarsen_ pmeshcoarsen
#else
#define meshcoarsen_ pmeshcoarsen_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshcoarsen_ MESHCOARSEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshcoarsen_ meshcoarsen
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshrefine_ PMESHREFINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshrefine_ pmeshrefine
#else
#define meshrefine_ pmeshrefine_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshrefine_ MESHREFINE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshrefine_ meshrefine
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshresetnodes_ PMESHRESETNODES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshresetnodes_ pmeshresetnodes
#else
#define meshresetnodes_ pmeshresetnodes_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshresetnodes_ MESHRESETNODES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshresetnodes_ meshresetnodes
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsavemesh_ PMESHSAVEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsavemesh_ pmeshsavemesh
#else
#define meshsavemesh_ pmeshsavemesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshsavemesh_ MESHSAVEMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshsavemesh_ meshsavemesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshrestoremesh_ PMESHRESTOREMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshrestoremesh_ pmeshrestoremesh
#else
#define meshrestoremesh_ pmeshrestoremesh_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshrestoremesh_ MESHRESTOREMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshrestoremesh_ meshrestoremesh
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshisdistorted_ PMESHISDISTORTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshisdistorted_ pmeshisdistorted
#else
#define meshisdistorted_ pmeshisdistorted_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define meshisdistorted_ MESHISDISTORTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define meshisdistorted_ meshisdistorted
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL meshsetup_(Mesh mesh, int *ierr ){
*ierr = MeshSetUp(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshsetfromoptions_(Mesh mesh, int *ierr ){
*ierr = MeshSetFromOptions(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshviewfromoptions_(Mesh mesh,char *title, int *ierr ){
*ierr = MeshViewFromOptions(
	(Mesh)PetscToPointer( (mesh) ),title);
}
void PETSC_STDCALL meshview_(Mesh mesh,PetscViewer *viewer, int *ierr ){
*ierr = MeshView(
	(Mesh)PetscToPointer( (mesh) ),*viewer);
}
void PETSC_STDCALL meshcopy_(Mesh mesh,Mesh newmesh, int *ierr ){
*ierr = MeshCopy(
	(Mesh)PetscToPointer( (mesh) ),
	(Mesh)PetscToPointer( (newmesh) ));
}
void PETSC_STDCALL meshduplicate_(Mesh mesh,Mesh *newmesh, int *ierr ){
*ierr = MeshDuplicate(
	(Mesh)PetscToPointer( (mesh) ),newmesh);
}
void PETSC_STDCALL meshdestroy_(Mesh mesh, int *ierr ){
*ierr = MeshDestroy(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshsetusercontext_(Mesh mesh,void*usrCtx, int *ierr ){
*ierr = MeshSetUserContext(
	(Mesh)PetscToPointer( (mesh) ),usrCtx);
}
void PETSC_STDCALL meshgetusercontext_(Mesh mesh,void**usrCtx, int *ierr ){
*ierr = MeshGetUserContext(
	(Mesh)PetscToPointer( (mesh) ),usrCtx);
}
void PETSC_STDCALL meshgetoptionsprefix_(Mesh mesh,char **prefix, int *ierr ){
*ierr = MeshGetOptionsPrefix(
	(Mesh)PetscToPointer( (mesh) ),prefix);
}
void PETSC_STDCALL meshprinthelp_(Mesh mesh, int *ierr ){
*ierr = MeshPrintHelp(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshcheckboundary_(Mesh mesh,MeshBoundary2D *bdCtx, int *ierr ){
*ierr = MeshCheckBoundary(
	(Mesh)PetscToPointer( (mesh) ),
	(MeshBoundary2D* )PetscToPointer( (bdCtx) ));
}
void PETSC_STDCALL meshsetboundary_(Mesh mesh,MeshBoundary2D *bdCtx, int *ierr ){
*ierr = MeshSetBoundary(
	(Mesh)PetscToPointer( (mesh) ),
	(MeshBoundary2D* )PetscToPointer( (bdCtx) ));
}
void PETSC_STDCALL meshsetreformboundary_(Mesh mesh,MeshBoundary2D *bdCtx, int *ierr ){
*ierr = MeshSetReformBoundary(
	(Mesh)PetscToPointer( (mesh) ),
	(MeshBoundary2D* )PetscToPointer( (bdCtx) ));
}
void PETSC_STDCALL meshpartition_(Mesh mesh, int *ierr ){
*ierr = MeshPartition(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshcoarsen_(Mesh mesh,PointFunction *area,Mesh *newmesh, int *ierr ){
*ierr = MeshCoarsen(
	(Mesh)PetscToPointer( (mesh) ),*area,newmesh);
}
void PETSC_STDCALL meshrefine_(Mesh mesh,PointFunction *area,Mesh *newmesh, int *ierr ){
*ierr = MeshRefine(
	(Mesh)PetscToPointer( (mesh) ),*area,newmesh);
}
void PETSC_STDCALL meshresetnodes_(Mesh mesh,PetscTruth *resetBd, int *ierr ){
*ierr = MeshResetNodes(
	(Mesh)PetscToPointer( (mesh) ),*resetBd);
}
void PETSC_STDCALL meshsavemesh_(Mesh mesh, int *ierr ){
*ierr = MeshSaveMesh(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshrestoremesh_(Mesh mesh, int *ierr ){
*ierr = MeshRestoreMesh(
	(Mesh)PetscToPointer( (mesh) ));
}
void PETSC_STDCALL meshisdistorted_(Mesh mesh,PetscTruth *flag, int *ierr ){
*ierr = MeshIsDistorted(
	(Mesh)PetscToPointer( (mesh) ),flag);
}
#if defined(__cplusplus)
}
#endif
