/* gmat.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "gvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatview_ PGMATVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatview_ pgmatview
#else
#define gmatview_ pgmatview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatview_ GMATVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatview_ gmatview
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatserialize_ PGMATSERIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatserialize_ pgmatserialize
#else
#define gmatserialize_ pgmatserialize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatserialize_ GMATSERIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatserialize_ gmatserialize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetsize_ PGMATGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetsize_ pgmatgetsize
#else
#define gmatgetsize_ pgmatgetsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetsize_ GMATGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetsize_ gmatgetsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetlocalsize_ PGMATGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetlocalsize_ pgmatgetlocalsize
#else
#define gmatgetlocalsize_ pgmatgetlocalsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetlocalsize_ GMATGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetlocalsize_ gmatgetlocalsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetgrid_ PGMATGETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetgrid_ pgmatgetgrid
#else
#define gmatgetgrid_ pgmatgetgrid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetgrid_ GMATGETGRID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetgrid_ gmatgetgrid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetorder_ PGMATGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetorder_ pgmatgetorder
#else
#define gmatgetorder_ pgmatgetorder_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetorder_ GMATGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetorder_ gmatgetorder
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetdiagonalconstrained_ PGMATGETDIAGONALCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetdiagonalconstrained_ pgmatgetdiagonalconstrained
#else
#define gmatgetdiagonalconstrained_ pgmatgetdiagonalconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetdiagonalconstrained_ GMATGETDIAGONALCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetdiagonalconstrained_ gmatgetdiagonalconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetdiagonalmf_ PGMATGETDIAGONALMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetdiagonalmf_ pgmatgetdiagonalmf
#else
#define gmatgetdiagonalmf_ pgmatgetdiagonalmf_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatgetdiagonalmf_ GMATGETDIAGONALMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatgetdiagonalmf_ gmatgetdiagonalmf
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatdiagonalscaleconstrained_ PGMATDIAGONALSCALECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatdiagonalscaleconstrained_ pgmatdiagonalscaleconstrained
#else
#define gmatdiagonalscaleconstrained_ pgmatdiagonalscaleconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatdiagonalscaleconstrained_ GMATDIAGONALSCALECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatdiagonalscaleconstrained_ gmatdiagonalscaleconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatorderconstrained_ PGMATORDERCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatorderconstrained_ pgmatorderconstrained
#else
#define gmatorderconstrained_ pgmatorderconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatorderconstrained_ GMATORDERCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatorderconstrained_ gmatorderconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatreorderfornonzerodiagonalconstrained_ PGMATREORDERFORNONZERODIAGONALCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatreorderfornonzerodiagonalconstrained_ pgmatreorderfornonzerodiagonalconstrained
#else
#define gmatreorderfornonzerodiagonalconstrained_ pgmatreorderfornonzerodiagonalconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatreorderfornonzerodiagonalconstrained_ GMATREORDERFORNONZERODIAGONALCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatreorderfornonzerodiagonalconstrained_ gmatreorderfornonzerodiagonalconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatreorder_ PGMATREORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatreorder_ pgmatreorder
#else
#define gmatreorder_ pgmatreorder_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatreorder_ GMATREORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatreorder_ gmatreorder
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluatealeoperatorgalerkin_ PGMATEVALUATEALEOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluatealeoperatorgalerkin_ pgmatevaluatealeoperatorgalerkin
#else
#define gmatevaluatealeoperatorgalerkin_ pgmatevaluatealeoperatorgalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluatealeoperatorgalerkin_ GMATEVALUATEALEOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluatealeoperatorgalerkin_ gmatevaluatealeoperatorgalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluateoperatorgalerkin_ PGMATEVALUATEOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluateoperatorgalerkin_ pgmatevaluateoperatorgalerkin
#else
#define gmatevaluateoperatorgalerkin_ pgmatevaluateoperatorgalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluateoperatorgalerkin_ GMATEVALUATEOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluateoperatorgalerkin_ gmatevaluateoperatorgalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluatealeconstrainedoperatorgalerkin_ PGMATEVALUATEALECONSTRAINEDOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluatealeconstrainedoperatorgalerkin_ pgmatevaluatealeconstrainedoperatorgalerkin
#else
#define gmatevaluatealeconstrainedoperatorgalerkin_ pgmatevaluatealeconstrainedoperatorgalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluatealeconstrainedoperatorgalerkin_ GMATEVALUATEALECONSTRAINEDOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluatealeconstrainedoperatorgalerkin_ gmatevaluatealeconstrainedoperatorgalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluateboundaryoperatorgalerkin_ PGMATEVALUATEBOUNDARYOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluateboundaryoperatorgalerkin_ pgmatevaluateboundaryoperatorgalerkin
#else
#define gmatevaluateboundaryoperatorgalerkin_ pgmatevaluateboundaryoperatorgalerkin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluateboundaryoperatorgalerkin_ GMATEVALUATEBOUNDARYOPERATORGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluateboundaryoperatorgalerkin_ gmatevaluateboundaryoperatorgalerkin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluatenewfields_ PGMATEVALUATENEWFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluatenewfields_ pgmatevaluatenewfields
#else
#define gmatevaluatenewfields_ pgmatevaluatenewfields_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatevaluatenewfields_ GMATEVALUATENEWFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatevaluatenewfields_ gmatevaluatenewfields
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatmatmultconstrained_ PGMATMATMULTCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatmatmultconstrained_ pgmatmatmultconstrained
#else
#define gmatmatmultconstrained_ pgmatmatmultconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatmatmultconstrained_ GMATMATMULTCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatmatmultconstrained_ gmatmatmultconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatmatmultmf_ PGMATMATMULTMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatmatmultmf_ pgmatmatmultmf
#else
#define gmatmatmultmf_ pgmatmatmultmf_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatmatmultmf_ GMATMATMULTMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatmatmultmf_ gmatmatmultmf
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatmatmulttransposeconstrained_ PGMATMATMULTTRANSPOSECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatmatmulttransposeconstrained_ pgmatmatmulttransposeconstrained
#else
#define gmatmatmulttransposeconstrained_ pgmatmatmulttransposeconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatmatmulttransposeconstrained_ GMATMATMULTTRANSPOSECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatmatmulttransposeconstrained_ gmatmatmulttransposeconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatsetboundary_ PGMATSETBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatsetboundary_ pgmatsetboundary
#else
#define gmatsetboundary_ pgmatsetboundary_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatsetboundary_ GMATSETBOUNDARY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatsetboundary_ gmatsetboundary
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreate_ PGMATCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreate_ pgmatcreate
#else
#define gmatcreate_ pgmatcreate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreate_ GMATCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreate_ gmatcreate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreaterectangular_ PGMATCREATERECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreaterectangular_ pgmatcreaterectangular
#else
#define gmatcreaterectangular_ pgmatcreaterectangular_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreaterectangular_ GMATCREATERECTANGULAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreaterectangular_ gmatcreaterectangular
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreatemf_ PGMATCREATEMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreatemf_ pgmatcreatemf
#else
#define gmatcreatemf_ pgmatcreatemf_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreatemf_ GMATCREATEMF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreatemf_ gmatcreatemf
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreateboundaryrestriction_ PGMATCREATEBOUNDARYRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreateboundaryrestriction_ pgmatcreateboundaryrestriction
#else
#define gmatcreateboundaryrestriction_ pgmatcreateboundaryrestriction_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define gmatcreateboundaryrestriction_ GMATCREATEBOUNDARYRESTRICTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define gmatcreateboundaryrestriction_ gmatcreateboundaryrestriction
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL gmatview_(GMat mat,PetscViewer *viewer, int *ierr ){
*ierr = GMatView(
	(GMat)PetscToPointer( (mat) ),*viewer);
}
void PETSC_STDCALL gmatserialize_(Grid grid,GMat *m,PetscViewer *viewer,PetscTruth *store, int *ierr ){
*ierr = GMatSerialize(
	(Grid)PetscToPointer( (grid) ),m,*viewer,*store);
}
void PETSC_STDCALL gmatgetsize_(GMat mat,int *M,int* N, int *ierr ){
*ierr = GMatGetSize(
	(GMat)PetscToPointer( (mat) ),M,N);
}
void PETSC_STDCALL gmatgetlocalsize_(GMat mat,int *m,int* n, int *ierr ){
*ierr = GMatGetLocalSize(
	(GMat)PetscToPointer( (mat) ),m,n);
}
void PETSC_STDCALL gmatgetgrid_(GMat m,Grid *grid, int *ierr ){
*ierr = GMatGetGrid(
	(GMat)PetscToPointer( (m) ),grid);
}
void PETSC_STDCALL gmatgetorder_(GMat m,VarOrdering *rowOrder,VarOrdering *colOrder, int *ierr ){
*ierr = GMatGetOrder(
	(GMat)PetscToPointer( (m) ),rowOrder,colOrder);
}
void PETSC_STDCALL gmatgetdiagonalconstrained_(GMat mat,GVec diag, int *ierr ){
*ierr = GMatGetDiagonalConstrained(
	(GMat)PetscToPointer( (mat) ),
	(GVec)PetscToPointer( (diag) ));
}
void PETSC_STDCALL gmatgetdiagonalmf_(GMat mat,GVec diag, int *ierr ){
*ierr = GMatGetDiagonalMF(
	(GMat)PetscToPointer( (mat) ),
	(GVec)PetscToPointer( (diag) ));
}
void PETSC_STDCALL gmatdiagonalscaleconstrained_(GMat mat,GVec l,GVec r, int *ierr ){
*ierr = GMatDiagonalScaleConstrained(
	(GMat)PetscToPointer( (mat) ),
	(GVec)PetscToPointer( (l) ),
	(GVec)PetscToPointer( (r) ));
}
void PETSC_STDCALL gmatorderconstrained_(GMat mat,MatOrderingType *type,IS *rowIS,IS *colIS, int *ierr ){
*ierr = GMatOrderConstrained(
	(GMat)PetscToPointer( (mat) ),*type,rowIS,colIS);
}
void PETSC_STDCALL gmatreorderfornonzerodiagonalconstrained_(GMat mat,double *atol,IS rowIS,IS colIS, int *ierr ){
*ierr = GMatReorderForNonzeroDiagonalConstrained(
	(GMat)PetscToPointer( (mat) ),*atol,
	(IS)PetscToPointer( (rowIS) ),
	(IS)PetscToPointer( (colIS) ));
}
void PETSC_STDCALL gmatreorder_(GMat mat,IS rowIS,IS colIS,PetscTruth *sparse,int *bw,double *frac,double *tol,GMat *newmat, int *ierr ){
*ierr = GMatReorder(
	(GMat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (rowIS) ),
	(IS)PetscToPointer( (colIS) ),*sparse,*bw,*frac,*tol,newmat);
}
void PETSC_STDCALL gmatevaluatealeoperatorgalerkin_(GMat M,int *numFields,int *sFields,VarOrdering sOrder,LocalVarOrdering *sLocOrder,
                                    int *tFields,VarOrdering tOrder,LocalVarOrdering *tLocOrder,int *op,PetscScalar *alpha,
                                    MatAssemblyType *type,void*ctx, int *ierr ){
*ierr = GMatEvaluateALEOperatorGalerkin(
	(GMat)PetscToPointer( (M) ),*numFields,sFields,
	(VarOrdering)PetscToPointer( (sOrder) ),*sLocOrder,tFields,
	(VarOrdering)PetscToPointer( (tOrder) ),*tLocOrder,*op,*alpha,*type,ctx);
}
void PETSC_STDCALL gmatevaluateoperatorgalerkin_(GMat M,GVec x,int *numFields,int *sFields,int *tFields,int *op,PetscScalar *alpha,
                                 MatAssemblyType *type,void*ctx, int *ierr ){
*ierr = GMatEvaluateOperatorGalerkin(
	(GMat)PetscToPointer( (M) ),
	(GVec)PetscToPointer( (x) ),*numFields,sFields,tFields,*op,*alpha,*type,ctx);
}
void PETSC_STDCALL gmatevaluatealeconstrainedoperatorgalerkin_(GMat M,int *numFields,int *sFields,VarOrdering sOrder,LocalVarOrdering *sLocOrder,
                                               int *tFields,VarOrdering tOrder,LocalVarOrdering *tLocOrder,int *op,PetscScalar *alpha,
                                               MatAssemblyType *type,void*ctx, int *ierr ){
*ierr = GMatEvaluateALEConstrainedOperatorGalerkin(
	(GMat)PetscToPointer( (M) ),*numFields,sFields,
	(VarOrdering)PetscToPointer( (sOrder) ),*sLocOrder,tFields,
	(VarOrdering)PetscToPointer( (tOrder) ),*tLocOrder,*op,*alpha,*type,ctx);
}
void PETSC_STDCALL gmatevaluateboundaryoperatorgalerkin_(GMat M,int *numFields,int *sFields,VarOrdering sOrder,LocalVarOrdering *sLocOrder,
                                         int *tFields,VarOrdering tOrder,LocalVarOrdering *tLocOrder,int *op,PetscScalar *alpha,
                                         MatAssemblyType *type,void*ctx, int *ierr ){
*ierr = GMatEvaluateBoundaryOperatorGalerkin(
	(GMat)PetscToPointer( (M) ),*numFields,sFields,
	(VarOrdering)PetscToPointer( (sOrder) ),*sLocOrder,tFields,
	(VarOrdering)PetscToPointer( (tOrder) ),*tLocOrder,*op,*alpha,*type,ctx);
}
void PETSC_STDCALL gmatevaluatenewfields_(GMat M,int *numFields,int *sFields,VarOrdering sOrder,LocalVarOrdering *sLocOrder,
                          int *tFields,VarOrdering tOrder,LocalVarOrdering *tLocOrder,PetscScalar *alpha,MatAssemblyType *type, int *ierr ){
*ierr = GMatEvaluateNewFields(
	(GMat)PetscToPointer( (M) ),*numFields,sFields,
	(VarOrdering)PetscToPointer( (sOrder) ),*sLocOrder,tFields,
	(VarOrdering)PetscToPointer( (tOrder) ),*tLocOrder,*alpha,*type);
}
void PETSC_STDCALL gmatmatmultconstrained_(GMat mat,GVec x,GVec y, int *ierr ){
*ierr = GMatMatMultConstrained(
	(GMat)PetscToPointer( (mat) ),
	(GVec)PetscToPointer( (x) ),
	(GVec)PetscToPointer( (y) ));
}
void PETSC_STDCALL gmatmatmultmf_(GMat mat,GVec x,GVec y, int *ierr ){
*ierr = GMatMatMultMF(
	(GMat)PetscToPointer( (mat) ),
	(GVec)PetscToPointer( (x) ),
	(GVec)PetscToPointer( (y) ));
}
void PETSC_STDCALL gmatmatmulttransposeconstrained_(GMat mat,GVec x,GVec y, int *ierr ){
*ierr = GMatMatMultTransposeConstrained(
	(GMat)PetscToPointer( (mat) ),
	(GVec)PetscToPointer( (x) ),
	(GVec)PetscToPointer( (y) ));
}
void PETSC_STDCALL gmatsetboundary_(GMat M,PetscScalar *diag,void*ctx, int *ierr ){
*ierr = GMatSetBoundary(
	(GMat)PetscToPointer( (M) ),*diag,ctx);
}
void PETSC_STDCALL gmatcreate_(Grid grid,GMat *gmat, int *ierr ){
*ierr = GMatCreate(
	(Grid)PetscToPointer( (grid) ),gmat);
}
void PETSC_STDCALL gmatcreaterectangular_(Grid grid,VarOrdering sOrder,VarOrdering tOrder,GMat *gmat, int *ierr ){
*ierr = GMatCreateRectangular(
	(Grid)PetscToPointer( (grid) ),
	(VarOrdering)PetscToPointer( (sOrder) ),
	(VarOrdering)PetscToPointer( (tOrder) ),gmat);
}
void PETSC_STDCALL gmatcreatemf_(Grid grid,VarOrdering sOrder,VarOrdering tOrder,GMat *gmat, int *ierr ){
*ierr = GMatCreateMF(
	(Grid)PetscToPointer( (grid) ),
	(VarOrdering)PetscToPointer( (sOrder) ),
	(VarOrdering)PetscToPointer( (tOrder) ),gmat);
}
void PETSC_STDCALL gmatcreateboundaryrestriction_(Grid grid,GMat *gmat, int *ierr ){
*ierr = GMatCreateBoundaryRestriction(
	(Grid)PetscToPointer( (grid) ),gmat);
}
#if defined(__cplusplus)
}
#endif
