#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>

#include "npnews.h"

int NP_News::sendmail()
{
   char buffer[ 1024 ], outbox_path[ 1024 ];
   snprintf( outbox_path, sizeof outbox_path, "%s/.peruser_spool/%s-OUTBOX",
             home, address );
   NP_File outbox;
   if ( outbox.openr( outbox_path ))
   {
      if ( errno == ENOENT )
         return 0;
      
      snprintf( error_message, sizeof error_message, "NP_News: "
                "sendmail(): %s", outbox.get_error());
      return 1;
   }

   NP_File sent;
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-SENT-MAIL",
             home, address );
   if ( sent.opena( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "sendmail(): %s", sent.get_error());
      return 1;
   }

   for( ; ; )
   {
      if ( stop )
      {
         strcpy( error_message, "NP_News: sendmail(): killed by SIGTERM." );
         return 1;
      }

      char *line;
      if (( line = outbox.get_string()) == NULL )
         break;

      FILE *pipe = popen( "sendmail -U -t", "w" );
      if ( pipe == NULL )
      {
         strcpy( error_message, "NP_News: "
                 "sendmail(): cannot execute sendmail." );
         return 1;
      }

      fputs( line, pipe );

      do
      {
        if (( line = outbox.get_string()) == NULL )
        {
           pclose( pipe );
           strcpy( error_message, "NP_News: "
                   "sendmail(): premature end of OUTBOX" );
           return 1;
        }

        if ( sent.put_string( line ))
        {
           pclose( pipe );
           snprintf( error_message, sizeof error_message, "NP_News: "
                     "sendmail(): %s", sent.get_error());
           return 1;
        }

        fputs( line, pipe );
      }
      while( strncmp( line, ".\r\n", 3 ));

      ++total_messages_transferred;
   }

   outbox.close();
   sent.close();

   truncate( outbox_path, 0 );

   return 0;
}
