#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>

#include "npsummary.h"

void list_callback( GtkWidget *widget, gint row, gint col,
                    GdkEvent *event, gpointer data )
{
   static int running = 0;
   if ( running )
      return;
   else
      running = 1;

   NP_Summary *summary =
      ( NP_Summary *)gtk_object_get_data( GTK_OBJECT( widget ), "summary" );

   int idx = summary->positions[ row ];

   np_thread_node_t *node =
      ( np_thread_node_t *)gtk_object_get_data(
         GTK_OBJECT( summary->items[ idx ] ), "node" );

   if ( node == NULL )
   {
      fprintf( stderr, "NULL node pointer in list_callback()\n" );
      return;
   }
   
   if ( node->parent != NULL )
      while( node->parent != NULL )
      {
         node = node->parent;
         gtk_tree_item_expand( GTK_TREE_ITEM( node->item ));         
      }

   summary->button = 1;
   
   gtk_tree_select_child( GTK_TREE( summary->tree_widget ), 
                          summary->items[ idx ] );

   summary->button = 0;

   running = 0;

   return;
}
