#include <ctype.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>

#include "npsummary.h"

void list_button_callback( GtkWidget *, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( summary->list_onscreen )
   {
      gdk_window_raise( summary->list_window->window );
      return;
   }

   summary->list_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   gtk_window_set_policy( GTK_WINDOW( summary->list_window ),
                          TRUE, TRUE, TRUE );
   summary->list_onscreen = 1;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npsummary_list:size", summary->home );

   FILE *file;
   if (( file = fopen( buffer, "r" )) == NULL )
      if ( errno != ENOENT )
         perror( "fopen" );
      else
         gtk_window_set_default_size( GTK_WINDOW( summary->list_window ), 
                                      550, 275 );
   else
   {
      fgets( buffer, sizeof buffer, file );
      int width = atoi( buffer );
      fgets( buffer, sizeof buffer, file );
      int height = atoi( buffer );

      fgets( buffer, sizeof buffer, file );
      int x = atoi( buffer );
      fgets( buffer, sizeof buffer, file );
      int y = atoi( buffer );

      fclose( file );

      gtk_window_set_default_size( GTK_WINDOW( summary->list_window ), 
                                   width, height );
      gtk_widget_set_uposition( summary->list_window, x, y );
   }

   gtk_window_set_title( GTK_WINDOW( summary->list_window ), 
                         "News Peruser Article List" );
   gtk_signal_connect( GTK_OBJECT( summary->list_window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_list_callback ), summary );
   gtk_signal_connect( GTK_OBJECT( summary->list_window ), "destroy",
                       GTK_SIGNAL_FUNC( close_list_callback ), summary );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 10 );
   gtk_container_add( GTK_CONTAINER( summary->list_window ), frame );

   GtkWidget *table = gtk_table_new( 20, 20, FALSE );
   gtk_widget_show( table );
   gtk_table_set_row_spacings( GTK_TABLE( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );

   GtkWidget *scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( scroll );

   char *titles[] = { "", "", "" };
   summary->list = gtk_clist_new_with_titles( 3, titles );
   gtk_widget_show( summary->list );
   gtk_object_set_data( GTK_OBJECT( summary->list ), "summary", summary );
   gtk_signal_connect( GTK_OBJECT( summary->list ), "select_row",
                       GTK_SIGNAL_FUNC( list_callback ), data );

   gtk_clist_set_column_width( GTK_CLIST( summary->list ), 0, 300 );
   gtk_clist_set_column_width( GTK_CLIST( summary->list ), 1, 300 );
   gtk_clist_set_column_width( GTK_CLIST( summary->list ), 2, 300 );

   gtk_scrolled_window_add_with_viewport(
         GTK_SCROLLED_WINDOW( scroll ), summary->list );
   gtk_table_attach_defaults( GTK_TABLE( table ), scroll, 0, 20, 1, 19 );

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 19, 19, 20 );
   gtk_widget_show( toolbar );

   GtkWidget *sub_button = gtk_toggle_button_new_with_label( " Subject " );
   gtk_widget_show( sub_button );
   summary->old_list_button = sub_button;
   gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( sub_button ), TRUE );
   gtk_object_set_data( GTK_OBJECT( sub_button ), "header", ( gpointer)0 );
   gtk_signal_connect( GTK_OBJECT( sub_button ), "clicked", 
                       GTK_SIGNAL_FUNC( sort_list_callback ), data );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, sub_button,
                               NULL, "Sort the list using Subject headers"
                               " as the sort keys.",
                               NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   GtkWidget *button = gtk_toggle_button_new_with_label( " Poster " );
   gtk_widget_show( button );
   gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), FALSE );
   gtk_object_set_data( GTK_OBJECT( button ), "header", ( gpointer)1 );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
                       GTK_SIGNAL_FUNC( sort_list_callback ), data );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, button,
                               NULL, "Sort the list using From headers "
                               "as the sort keys.",
                               NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   button = gtk_toggle_button_new_with_label( " Date " );
   gtk_widget_show( button );
   gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), FALSE );
   gtk_object_set_data( GTK_OBJECT( button ), "header", ( gpointer)2 );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked", 
                       GTK_SIGNAL_FUNC( sort_list_callback ), data );

   gtk_toolbar_insert_element( GTK_TOOLBAR( toolbar ),
                               GTK_TOOLBAR_CHILD_WIDGET, button,
                               NULL, "Sort the list using Date headers "
                               "as the sort keys.",
                               NULL, NULL, NULL, NULL,
                               GTK_TOOLBAR( toolbar )->num_children );

   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 19, 20, 19, 20 );
   gtk_widget_show( toolbar );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " close ",
                            "Close the article list window.", NULL, NULL,
                            GTK_SIGNAL_FUNC( close_list_callback ), data );

   sort_list_callback( sub_button, data );

   gtk_widget_show( summary->list_window );

   return;
}

void close_list_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( !summary->list_onscreen )
      return;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npsummary_list:size", summary->home );

   FILE *file;
   if (( file = fopen( buffer, "w" )) == NULL )
   {
      perror( "fopen" );
      exit( 1 );
   }

   int width, height, x, y;
   gdk_window_get_size( summary->list_window->window, &width, &height );
   gdk_window_get_root_origin( summary->list_window->window, &x, &y );

   fprintf( file, "%d\n%d\n%d\n%d\n", width, height, x, y );
   fclose( file );

   summary->list_onscreen = 0;
   gtk_widget_destroy( summary->list_window );
   summary->list_window = NULL;
   
   if ( summary->positions != NULL )
   {
      free( summary->positions );
      summary->positions = NULL;
   }

   return;
}
