#include <signal.h>

#include "npsummary.h"

extern void *summary_p;

void SIGUSR1_handler( int signo )
{
   NP_Summary *summary = ( NP_Summary *)summary_p;

   if ( summary->reading )
      return;

   summary->reading = 1;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/.current_group",
             summary->home );
   NP_File file;
   if ( file.openw( buffer ))
      file.print_error();
   else
   {
      snprintf( buffer, sizeof buffer, "%s\n%s\n", summary->server,
                summary->group );
      if ( file.put_string( buffer ))
         file.print_error();
   }

   summary->write_read_file();
   summary->update_tree();
   summary->current_node = NULL;
   summary->selected_item = NULL;

   file.close();

   signal( SIGUSR1, SIGUSR1_handler );
   summary->reading = 0;

   return;
}
