#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::clear()
{
   group_list_t *pointer = group_list;

   if ( server_names.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "clear(): %s", server_names.get_error() );
      return 1;
   }
   
   for( int i = 0; i < total; ++i )
   {
      if ( pointer->server != NULL )
         free( ( char *)pointer->server );

      if ( pointer->group_names != NULL )
         delete pointer->group_names;

      ++pointer;
   }

   free( group_list );
   group_list = NULL;

   authentication.clear();
   
   return 0;
}

   
