#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include "npserver.h"

int NP_Server::get_list()
{
   FILE *file;
   char buffer[ 1024 ];

   snprintf( buffer, sizeof buffer, "%s/.peruser_spool", home );
   if ( mkdir( buffer, ( S_IRUSR | S_IWUSR | S_IXUSR )))
      if ( errno != EEXIST )
      {
         perror( "mkdir" );
         exit( 1 );
      }
   
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-LIST", home,
             address );

   if (( file = fopen( buffer, "r" )) == NULL )
   {
      if ( errno == ENOENT )
         return getlist( ( char *)address );
      else
         return 1;
   }
   else
   {
      fclose( file );
      int result;
      if (( result = get_newgroups( ( char *)address )))
      {
         if ( result == 2 )
            snprintf( error_message, sizeof error_message, "NP_Server: "
                      "get_list(): no new groups on %s.", address );
         else
            if ( result == 3 )
               result = getlist( ( char *)address );
         
         return result;
      }
   }
   
   return 0;
}
