#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npauthentication.h"

int NP_Authentication::load()
{
   int result;
   if (( result = config_file.openr( config_path )))
      if ( errno != ENOENT )
      {
         snprintf( error_message, sizeof error_message, "NP_Authentication: "
                   "load(): %s", config_file.get_error() );
         return 1;
      }

   int i = 4;
   if ( !result )
      while( i-- )
         if ( config_file.get_string() == NULL )
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Authentication: "
                      "load(): %s", config_file.get_error() );
            return 1;
         }

   if ( !result )
      while( config_file.get_string() != NULL )
      {
         char *line, user[ 1024 ], pass[ 1024 ];

         if (( line = config_file.get_string()) == NULL )
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Authentication: "
                      "load(): %s", config_file.get_error() );
            return 1;
         }

         strcpy( user, line );
         
         if (( line = config_file.get_string()) == NULL )
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Authentication: "
                      "load(): %s", config_file.get_error() );
            return 1;
         }

         strcpy( pass, line );
         
         if ( strtok( user, "\n" ) == NULL )
            *user = '\0';
      
         if ( user_list.add_item( user ))
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Authentication: "
                      "load(): %s", user_list.get_error() );
            return 1;
         }

         if ( strtok( pass, "\n" ) == NULL )
            *pass = '\0';
      
         if ( pass_list.add_item( pass ))
         {
            snprintf( error_message, sizeof error_message,
                      "NP_Authentication: "
                      "load(): %s", pass_list.get_error() );
            return 1;
         }
      }
   
   config_file.close();

   return 0;
}

