#include "npconfig.h"

void NP_Config::init_newsgroups( GtkWidget *frame )
{
   // table
   
   GtkWidget *table = gtk_table_new( 10, 10, FALSE );
   gtk_widget_show( table );
   gtk_table_set_col_spacings( GTK_TABLE( table ), 10 );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );

   // pane

   GtkWidget *pane = gtk_hpaned_new();
   gtk_widget_show( pane );
   gtk_table_attach_defaults( GTK_TABLE( table ), pane, 0, 10, 0, 9 );

   // scroll

   GtkWidget *scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( scroll );
   gtk_widget_set_usize( scroll, 150, 175 );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( scroll ),
                                   GTK_POLICY_AUTOMATIC,
                                   GTK_POLICY_AUTOMATIC );
   gtk_paned_add1( GTK_PANED( pane ), scroll );
   
   // vbox
   
   server_buttons_vbox = gtk_vbox_new( FALSE, 0 );
   gtk_widget_show( server_buttons_vbox );
   gtk_object_set_data( GTK_OBJECT( server_buttons_vbox ), "config", this );
   gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll ), 
                                          server_buttons_vbox );
   
   int total = subscription.get_total();

   // radio buttons

   const char *first_address = NULL;

   if ( total )
   {
      if (( server_buttons =
            ( GtkWidget **)calloc( total, sizeof *server_buttons )) == NULL )
      {
         perror( "calloc" );
         exit( 1 );
      }

      for( int i = 0; i < total; ++i )
      {
         const char *address = subscription[ i ];
         if ( address == NULL )
         {
            subscription.print_error();
            return;
         }

         if ( !i ) first_address = address;
      
         create_server_button( i, address );
      }
   }
   
   // clist
   
   GtkWidget *group_scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( group_scroll );

   static char *titles[] = { "Subscribed Groups", "Last Article Number Seen" };
   group_clist = gtk_clist_new_with_titles( 2, titles );
   gtk_widget_show( group_clist );
   gtk_clist_set_selection_mode( GTK_CLIST( group_clist ),
                                 GTK_SELECTION_EXTENDED );
   gtk_clist_set_column_width( GTK_CLIST( group_clist ), 0, 200 );
   gtk_object_set_data( GTK_OBJECT( server_buttons_vbox ), "clist",
                        group_clist );
   gtk_container_add( GTK_CONTAINER( group_scroll ), group_clist );
   gtk_paned_add2( GTK_PANED( pane ), group_scroll );

   // edit_button

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Edit Newsgroups ",
                            "Add or remove newsgroups from the list of "
                            "subscribed groups.", NULL, NULL,
                            GTK_SIGNAL_FUNC( edit_button_callback ), this );
   
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 5, 10, 9, 10 );

   if ( total )
      address_buttons_callback( first_button, ( char *)first_address );
   else
      current_server = -1;
   
   return;
}
