#include "npconfig.h"
#include "ctype.h"

void NP_Config::create_server_button( int i, const char *server )
{
   char buffer[ 256 ];
   snprintf( buffer, sizeof buffer, " %s ", server );
   for( char *pointer = buffer; *pointer; ++pointer )
      *pointer = toupper( *pointer );
   
   GSList *group = ( i ? gtk_radio_button_group(
      GTK_RADIO_BUTTON( first_button )) : NULL );
   GtkWidget *button =
      gtk_radio_button_new_with_label( group, buffer );
   gtk_widget_show( button );
   gtk_box_pack_start( GTK_BOX( server_buttons_vbox ), button,
                       FALSE, FALSE, 0 );
   gtk_signal_connect( GTK_OBJECT( button ), "clicked",
                       GTK_SIGNAL_FUNC( address_buttons_callback ),
                       ( gpointer )server );

   if ( !i )
      first_button = button;

   server_buttons[ i ] = button;
   
   return;
}
