#include <signal.h>
#include <unistd.h>
#include <errno.h>

#include "npconfig.h"

extern GtkWidget *toplevel_window;

NP_Config::NP_Config( int *argc, char ***argv )
{
   gtk_init( argc, argv );

   signal( SIGUSR1, SIG_IGN );
   signal( SIGUSR2, SIGUSR2_handler );
   signal( SIGTERM, SIGTERM_handler );
   signal( SIGQUIT, SIGTERM_handler );
   signal( SIGSEGV, signal_handler );
   
   dirty = 0;

   home = getenv( "HOME" );
   char buffer[ 1024 ], second_buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.npconfig:pid", home );
   FILE *file;
   if (( file = fopen( buffer, "r" )) != NULL )
   {
      if ( fgets( second_buffer, sizeof second_buffer, file ) == NULL )
         exit( 0 );

      fclose( file );
      
      pid_t pid = atoi( second_buffer );
      if ( !( pid > 0 && kill( pid, SIGUSR2 ) && errno == ESRCH ))
         exit( 0 );
   }

   if (( file = fopen( buffer, "w" )) == NULL )
   {
      perror( "fopen" );
      exit( 1 );
   }
   fprintf( file, "%d", getpid() );
   fclose( file );
   
   server_frames = server_buttons = NULL;

   message_label = message_window = group_clist = server_buttons_vbox =
      message_button = first_button = NULL;

   search_text[ 0 ] = '\0';
   regex_alloc = 0;
   
   stop = 0;
   folder_clist_line = -1;

   deleted.allow_duplicates( 0 );
   temp_deleted.allow_duplicates( 0 );

   if (( argv_copy = ( char **)calloc( *argc + 1, sizeof **argv )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   int i;
   for( i = 0; i < *argc; ++i )
      if (( argv_copy[ i ] = strdup( *argv[ i ] )) == NULL )
      {
         perror( "calloc" );
         exit( 1 );
      }

   argv_copy[ i ] = NULL;

   // window
   
   window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   toplevel_window = window;
   gtk_window_set_title( GTK_WINDOW( window ), "News Peruser Configuration" );
   gtk_window_set_policy( GTK_WINDOW( window ), TRUE, TRUE, TRUE );
   gtk_widget_realize( window );

   gtk_container_border_width( GTK_CONTAINER( window ), 10 );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( exit_button_callback ), this );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( exit_button_callback ), this );
   
   // table

   GtkWidget *table = gtk_table_new( 10, 3, FALSE );
   gtk_widget_show( table );
   gtk_table_set_row_spacings( GTK_TABLE( table ), 10 );
   gtk_container_add( GTK_CONTAINER( window ), table );

   // notebook
   
   GtkWidget *notebook = gtk_notebook_new();
   gtk_widget_show( notebook );
   gtk_table_attach_defaults( GTK_TABLE( table ), notebook, 0, 3, 0, 9 );

   // toolbar

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );

   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 3, 9, 10 );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Exit ",
                            "Exit program without saving changes.", NULL, NULL,
                            GTK_SIGNAL_FUNC( exit_button_callback ), this );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Save ",
                            "Save the current configuration to disk",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( save_button_callback ), this );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Save & Exit ",
                            "Save the current configuration to disk and"
                            " exit program.", NULL, NULL,
                            GTK_SIGNAL_FUNC( save_exit_button_callback ),
                            this );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));
   
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Reload ",
                            "Reload all configuration information from disk,"
                            " discarding any changes made since the"
                            " last save.", NULL, NULL,
                            GTK_SIGNAL_FUNC( reload_button_callback ), this );
   
   // general
   
   GtkWidget *frame = gtk_frame_new( " General Settings" );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
   GtkWidget *label = gtk_label_new( " General " );
   gtk_widget_show( label );
   gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );

   init_general( frame );

   // servers

   frame = gtk_frame_new( " News Servers " );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
   label = gtk_label_new( " Servers " );
   gtk_widget_show( label );
   gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );

   init_servers( frame );

   // newsgroups

   frame = gtk_frame_new( " Newsgroups " );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
   label = gtk_label_new( " Newsgroups " );
   gtk_widget_show( label );
   gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );

   init_newsgroups( frame );
   
   // persistent folders

   frame = gtk_frame_new( " Folders " );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
   label = gtk_label_new( " Folders " );
   gtk_widget_show( label );
   gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), frame, label );

   init_folders( frame );
   
   set_size();
   gtk_widget_show( window );

   return;
}
