#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"

int NP_Node::get_group_stats( char *group, int *messagesp, int *unseenp,
                              int *requestedp, int *headersp )
{
   if ( group == NULL )
   {
      strcpy( error_message, "NP_Node: get_group_stats(): NULL group name "
              "passed as argument." );
      return 1;
   }

   NP_Group **pointer = groups;
   int i;
   for( i = 0; i < total_groups; ++i )
   {
      if ( !strcmp( ( *pointer )->get_name(), group ))
         break;
      ++pointer;
   }
   
   if ( i == total_groups )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Node: get_group_stats(): no such group has"
                " been added to this node object: %s", group );
      return 1;
   }
   
   int messages, unseen, requested, headers;
   if ( ( *pointer )->get_stats( &messages, &unseen, &requested, &headers ))
   {
      snprintf( error_message, sizeof error_message, "NP_Node: "
                "get_group_stats(): %s", ( *pointer )->get_error() );
      return 1;
   }

   if ( messagesp != NULL )
      *messagesp = messages;

   if ( unseenp != NULL )
      *unseenp = unseen;

   if ( requestedp != NULL )
      *requestedp = requested;

   if ( headersp != NULL )
      *headersp = headers;

   return 0;
}

           
