#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

int NP_Collections::do_all_servers( FILE *file, NP_Stringarray& output_lines )
{
   int total;
   if ( tree.get_totals( &total, NULL, NULL, NULL, NULL, NULL ))
   {
      tree.print_error();
      return 1;
   }

   if ( !total )
      return 0;

   NP_Stringarray server_array;
   if ( tree.get_nodes( server_array ))
   {
      tree.print_error();
      return 1;
   }

   for( int i = 0; i < total; ++i )
   {
      char *server_name = ( char *)server_array[ i ];
      if ( server_name == NULL )
      {
         server_array.print_error();
         continue;
      }

      if ( do_one_server( server_name, file, output_lines ))
         return 1;
   }

   return 0;
}
