#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "npfile.h"

int NP_File::seek( long offset, int whence )
{
   if ( !is_open )
   {
      snprintf( error_message, sizeof error_message,
                "NP_File: seek(): No file is open for this object." );
      return 1;
   }

   if ( fseek( stream, offset, whence ))
   {
      snprintf( error_message, sizeof error_message,
                "NP_File: seek(): fseek() returned error: %s",
                strerror( errno ));
      return 1;
   }

   return 0;
}
