#include "npfile.h"

extern int stop;

enum np_news_t { NP_HEADERS, NP_ARTICLES, NP_REQUESTS };

class NP_News
{
   char *address, *group, *home, error_message[ 1024 ];

   int fd, seconds, timeout, last_spooled, total_requests,
      total_messages_transferred, head;

   do_connect( const char *, char * );

   int wait_for_activity( int );
   int open_server( char * );

   int get_string( char *buffer, int size );
   int put_string( char * );

   int np_fgets( char *, int );
   int np_read( char * );
   void np_fputs_error();
   int np_fputs( char * );

   struct np_requests_list_t
   {
      char *server;
      char *group;
      char *request;
      int found;
   }
   *requests_list;

   get_messages( int, int );
   get_requests_list();
   void destroy_requests_list();
   get_requests();
   get_folder_requests_list();
   get_folder_requests();
   remove_headers();
   post_articles();
   sendmail();

   get_last_spooled();
   char *change_group( char * );
   rewrite_newsrc( int );
   has_xover();
   get_xover_data( int, int, NP_File&, NP_File& );
   get_message_data( int, int, NP_File&, NP_File& );
   check_response( char * );

 public:

   NP_News();
   ~NP_News();

   transfer( char *,               // server address
                                   // in ~/.peruser4-config.
             char *,                                // group name
             np_news_t,                         // what we want
             int );                                   // how many

   get_transferred() { return total_messages_transferred; };
   disconnect();
   
   void print_error() { fprintf( stderr, "%s\n", error_message ); };
   char *get_error() { return error_message; };
};
