#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>

#include "misc.h"

void (*my_err)(const char *,const char *,int,const char *,...)=std_err;

void
std_err(const char *file,const char *func,int line,
	const char *fmt,...) {

  va_list args;

  if (!fmt)
    return;

  va_start(args,fmt);
  if (file && func && line) {
    fprintf(stderr,"Error in file %s, function %s, line %d\n",file,func,line);
    if (errno) {
      perror(func);
      errno=0;
    }
  }
  vfprintf(stderr,fmt,args);
  fflush(stderr);
  va_end(args);

}

