#include <errno.h>
#include <stdarg.h>

#include "indexl.h"

int 
ierr(const char *fmt,...) {
  
  va_list args;

  if (errno) {
    perror("");
    errno=0;
  } else
    fprintf(stderr,"\n");

  va_start(args,fmt);
  vfprintf(stderr,fmt,args);
  va_end(args);
  fprintf(stderr,"\n");

  return 0;

}

void *
bsearch1(const void *k,const void *b,size_t n,size_t s,
	 int (*c)(const void *,const void *),int *i) {

  const char *v;
  size_t l,u,q;
  int j;

  l=0;
  u=n;

  while (l<u) {

    q=(l+u)/2;
    v=(char *)b+s*q;

    if (!(j=c(k,v))) {
      *i=1;
      return (void *)v;
    }

    if (j<0) 
      u=q;
    else
      l=q+1;

  }

  *i=0;
  return (void *)((char *)b+s*l);

}



