/*
 * Copyright (C) 2001 Philip Blundell <philb@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <pwd.h>
#include <sys/types.h>
#include <shadow.h>
#include <crypt.h>
#include <unistd.h>
#include <stdlib.h>

#include <gtk/gtk.h>

static const char *current_username;
static GtkWidget *label_result;

static void
set_username(GtkWidget *widget,
	     gpointer data)
{
  current_username = (const char *)data;
}

static void
slurp_passwd(GtkWidget *menu)
{
  struct passwd *pw;
  while (pw = getpwent(), pw != NULL)
    {
      const char *name = g_strdup(pw->pw_name);
      GtkWidget *item = gtk_menu_item_new_with_label(name);
      gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(set_username), (gpointer)name);
      gtk_menu_append(GTK_MENU(menu), item);
      if (current_username == NULL)
	current_username = name;
    }
}

static void
enter_callback(GtkWidget *widget,
	       GtkWidget *entry)
{
  gchar *pwstr;
  struct passwd *pwe;
  struct spwd *spe;
  char *p;

  if (current_username == NULL)
    return;

  pwstr = gtk_entry_get_text(GTK_ENTRY(entry));
  gtk_entry_set_text(GTK_ENTRY(entry), "");

  pwe = getpwnam(current_username);
  if (pwe == NULL)
    goto login_incorrect;

  spe = getspnam(current_username);
  if (spe)
    pwe->pw_passwd = spe->sp_pwdp;

  p = crypt(pwstr, pwe->pw_passwd);
  if (strcmp(p, pwe->pw_passwd))
    goto login_incorrect;

  setuid(pwe->pw_uid);
  setgid(pwe->pw_gid);
  setenv("HOME", pwe->pw_dir, 1);
  chdir(pwe->pw_dir);

  execl("/etc/X11/Xsession", "/etc/X11/Xsession", NULL);

  return;

 login_incorrect:
  gtk_label_set_text(GTK_LABEL(label_result), "Login incorrect");
}

int
main(int argc, char *argv[])
{
  GtkWidget *window, *label_login, *label_password;
  GtkWidget *option, *entry, *menu;
  GtkWidget *table;

  gtk_init(&argc, &argv);
  
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  label_login = gtk_label_new("login:");
  label_password = gtk_label_new("password:");
  label_result = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(label_login), 1.00f, 0.5f);
  gtk_misc_set_alignment(GTK_MISC(label_password), 1.00f, 0.5f);
  
  entry = gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(entry), FALSE);
  gtk_entry_set_max_length(GTK_ENTRY(entry), 16);

  option = gtk_option_menu_new();
  menu = gtk_menu_new();
  slurp_passwd(menu);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(option), menu);

  gtk_signal_connect(GTK_OBJECT(entry), "activate",
		     GTK_SIGNAL_FUNC(enter_callback), entry);

  table = gtk_table_new(2, 3, FALSE);
  gtk_widget_set_usize(option, -1, 32);
  gtk_widget_set_usize(label_result, -1, 32);
  gtk_table_attach(GTK_TABLE(table), label_login, 0, 1, 0, 1, 0, 0, 5, 2);
  gtk_table_attach(GTK_TABLE(table), label_password, 0, 1, 1, 2, 0, 0, 5, 2);
  gtk_table_attach(GTK_TABLE(table), option, 1, 2, 0, 1, GTK_EXPAND | GTK_FILL, 0, 5, 2);
  gtk_table_attach(GTK_TABLE(table), entry, 1, 2, 1, 2, GTK_EXPAND | GTK_FILL, 0, 5, 2);
  gtk_table_attach(GTK_TABLE(table), label_result, 1, 2, 2, 3, GTK_EXPAND | GTK_FILL, 0, 5, 2);

  gtk_container_add(GTK_CONTAINER(window), table);

  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_show_all(window);
  gtk_widget_grab_focus(entry);

  gtk_main();

  return 0;
}
