/*
**  Sendmail.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/Sendmail.h>

#include <Pantomime/Constants.h>
#include <Pantomime/Message.h>
#include <Pantomime/NSString+Extensions.h>

#include <Foundation/NSDebug.h>
#include <Foundation/NSFileHandle.h>
#include <Foundation/NSFileManager.h>
#include <Foundation/NSPathUtilities.h>
#include <Foundation/NSProcessInfo.h>
#include <Foundation/NSTask.h>

#include <stdio.h>

@implementation Sendmail

- (id) initWithPathToSendmail: (NSString *) thePath;
{
  self = [super init];

  [self setPathToSendmail: thePath];

  return self;
}

- (void) dealloc
{
  RELEASE(pathToSendmail);

  [super dealloc];
}

- (NSString *) pathToSendmail
{
  return pathToSendmail;
}

- (void) setPathToSendmail: (NSString *) thePath
{
  RETAIN(thePath);
  RELEASE(pathToSendmail);
  pathToSendmail = thePath;
}


//
//
//
- (BOOL) sendMessage: (Message *) theMessage
{
  return [self sendMessageFromRawSource: [theMessage dataValue]];
}


//
//
//
- (BOOL) sendMessageFromRawSource: (NSData *) theData
{
  if ([self pathToSendmail] == nil)
    {
      NSDebugLog(@"Sendmail: -sendMessageFromRawSource: The mailer program was not specified.");
      return NO;
    }
  else
    {
      NSFileHandle *aFileHandle;
      NSTask *aTask;

      NSString *aString, *aFilename;
      NSRange aRange;
      
      aFilename = [NSString stringWithFormat:@"%@/%d_%@", NSTemporaryDirectory(), 
			    [[NSProcessInfo processInfo] processIdentifier],
			    NSUserName()];
      
      if ( ![theData writeToFile: aFilename
		     atomically: YES] )
	{
	  NSDebugLog(@"Unable to write the raw source of the message to %@ when sending using a local mailer. Aborting.", aFilename);
	  return NO;
	}
  
      aFileHandle = [NSFileHandle fileHandleForReadingAtPath: aFilename];
      aTask = [[NSTask alloc] init];
      
      // We build our right string
      aString = [[self pathToSendmail] stringByTrimmingWhiteSpaces];
      
      // We verify if our program to lauch has any arguments
      aRange = [aString rangeOfString: @" "];

      if ( aRange.length )
	{
	  [aTask setLaunchPath: [aString substringToIndex: aRange.location]];      
	  [aTask setArguments: [[aString substringFromIndex: (aRange.location + 1)] 
				 componentsSeparatedByString: @" "]];
	}
      else
	{
	  [aTask setLaunchPath: aString];
	}
     
      [aTask setStandardInput: aFileHandle];
      
      // We launch our task
      [aTask launch];
      

      [aFileHandle closeFile];
      
      [[NSFileManager defaultManager] removeFileAtPath: aFilename
				      handler: nil];
      RELEASE(aTask);
    }

  return YES;
}

@end
