/*
**  LocalMessage.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_LocalMessage
#define _Pantomime_H_LocalMessage

#include <Pantomime/Message.h>

#import <Foundation/NSCoder.h>
#import <Foundation/NSData.h>
#import <Foundation/NSString.h>

@interface LocalMessage : Message <NSCoding>
{
  @private
    NSString *mailFilename; // name of file in which message is stored.
    int messageType;	    // mbox, maildir, etc.
    long filePosition;      //
    long bodyFilePosition;  //
}


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// access / mutation methods
//
- (long) filePosition;
- (void) setFilePosition: (long) theFilePosition;

- (long) bodyFilePosition;
- (void) setBodyFilePosition: (long) theBodyFilePosition;

- (int) messageType;
- (void) setMessageType: (int) theType;

- (NSString *) mailFilename;
- (void) setMailFilename: (NSString *) theFilename;

@end

#endif // _Pantomime_H_LocalMessage
