/*
**  InternetAddress.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_InternetAddress
#define _Pantomime_H_InternetAddress

#import <Foundation/NSCoder.h>
#import <Foundation/NSData.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

#define TO  1
#define CC  2
#define BCC 3

#define RESENT_TO 4
#define RESENT_CC 5
#define RESENT_BCC 6

@interface InternetAddress : NSObject <NSCoding>
{
  NSString *address, *personal;
  int type;

  id container; // needed for scripting
}

- (id) init;
- (id) initWithString: (NSString *) theString;
- (id) initWithPersonal: (NSString *) thePersonal
             andAddress: (NSString *) theAddress;

- (NSString *) address;
- (void) setAddress: (NSString *) theAddress;

- (NSString *) personal;
- (void) setPersonal: (NSString *) thePersonal;

- (int) type;
- (void) setType: (int) theType;

- (NSString *) unicodeStringValue;
- (NSData *) dataValue;

- (id) container;
- (void) setContainer: (id) aContainer;


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

@end

@interface ToRecipient: InternetAddress
{    
}
- (id) init;
@end

@interface CcRecipient: InternetAddress
{
}
- (id) init;
@end

@interface BccRecipient: InternetAddress
{
}
- (id) init;
@end


#endif // _Pantomime_H_InternetAddress
