//
// C++ Implementation: emptytagfilter
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "emptytagfilter.h"


#include <QVariant>
#include <QTimer>

// NTagModel
#include "vocabularymodel.h"
#include "vocabularymodelrole.h"

// NPlugin
#include "debtagsplugincontainer.h"
#include "debtagshelper.h"

namespace NTagModel {

EmptyTagFilter::EmptyTagFilter(const VocabularyModel* pModel, const Xapian::Database& xapian, QObject* pParent)
 : QSortFilterProxyModel(pParent), _xapian(xapian)
{
	_tagSelectionHasChanged = false;
	_pVocabularyModel = pModel;
	connect(_pVocabularyModel, SIGNAL(dataChanged(QModelIndex, QModelIndex)), SLOT(tagSelectionChanged()));
}


EmptyTagFilter::~EmptyTagFilter()
{
}


bool EmptyTagFilter::filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const
{
	// TODO: Do not compute the companion tags every time the filterMethod is called, but only when the selected tags change

	// tree filtering -> if a child is shown, also show the facet
	QModelIndex current = sourceModel()->index(sourceRow, 0, sourceParent);
	if (!current.isValid())
	{
		qDebug("[EmptyTagFilter::filterAcceptsRow] Invalid model index!");
		return false;
	}
	for( int i = 0; i < sourceModel()->rowCount(current); ++i )
	{
		const QModelIndex child = current.child(i, 0);
		if (filterAcceptsRow(i, current))
			return true;
	}

	// facets without tags will not be shown
	if (sourceModel()->data(current, TypeRole).toInt() == FacetTypeItem)
		return false;
	
	// Also apply filtering if no tags are selected, because there are tags in the vocab
	// which are not used
	//if (_pVocabularyModel->selectedTags().empty())
	//	return true;

	Xapian::Enquire enq(_xapian);
	set<Tag> includeTags = _pVocabularyModel->selectedTags();
 	Tag tag = sourceModel()->data(current, TagRole).value<TagWrapper>().tag;
	includeTags.insert(tag);
	
	static set<string> companionTags;
	if (_tagSelectionHasChanged) {
		companionTags = _pVocabularyModel->selectedTags();
		_tagSelectionHasChanged = false;
	}

	
	
	set<string> terms;		
	for (set<Tag>::const_iterator it = includeTags.begin(); it != includeTags.end(); ++it)
	{
		terms.insert(string("XT") + *it);
	}
	Xapian::Query query(Xapian::Query::OP_AND, terms.begin(), terms.end());
	enq.set_query(query);
	Xapian::MSet match = enq.get_mset(0, 1);
	return (match.size() != 0);
	return true;
 	// if no tags are selected, the companion tags are useless -> show only those tags
 	// which have a cardinality > 0
// 	if (_pVocabularyModel->selectedTags().empty())
// 		return _pVocabularyModel->debtags()->getCardinality(tag) > 0;
/*	static set<Tag> companionTags;
	if (_tagSelectionHasChanged) {
		companionTags = _pVocabularyModel->debtags()->getCompanionTags(_pVocabularyModel->selectedTags());
		_tagSelectionHasChanged = false;
	}*/
//	if (companionTags.find(tag) == companionTags.end())
//		qDebug("Tag " + toQString(tag.fullname()) + " is hidden as non-companion");
//	else 
//		qDebug("Tag " + toQString(tag.fullname()) + " is shown as companion");
// 	return companionTags.find(tag) != companionTags.end();
}


void EmptyTagFilter::tagSelectionChanged()
{
	_tagSelectionHasChanged = true;
	// queue evaluation of tags
// 	QTimer::singleShot(3000, this, SLOT(onSelectionChangedTimeout()));
	invalidateFilter();
}

void EmptyTagFilter::onSelectionChangedTimeout()
{
	invalidateFilter();
}


}	// NTagModel 

#undef emit	
#include <ept/debtags/debtags.tcc>
