//
// C++ Interface: emptytagfilter
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __NTAGMODEL_EMPTYTAGFILTER_H_2007_04_06
#define __NTAGMODEL_EMPTYTAGFILTER_H_2007_04_06

#include <set>

#include <QSortFilterProxyModel>

namespace ept {
namespace debtags {
class Tag;
class Debtags;
}
}


using namespace std;

namespace NPlugin
{
	class DebtagsPluginContainer;
}

namespace NTagModel {

class VocabularyModel;

/** Filters out all tags, that would lead to an empty search result.
  *
  * To filter out the tags, the set of currently selected tags (_selectedTags) is considered
  * and only tags which are assigned to at least one of packages selected by that tag set are shown.
  *
  * @author Benjamin Mesing <bensmail@gmx.net>
  */
class EmptyTagFilter : public QSortFilterProxyModel
{
	Q_OBJECT
	
	typedef ept::debtags::Tag Tag;
	typedef ept::debtags::Debtags Debtags;

	/** The model holding the information about the selected tags.
	  *
	  * This information is required, to be able to access the selected tags.
	  * The model is also used to access the Debtags object.
	  */
	const VocabularyModel* _pVocabularyModel;
	/** @brief This indicates if the tag selection has changed since the last calculation of the companion tags.
	  */
	mutable bool _tagSelectionHasChanged;
public:
	EmptyTagFilter(const VocabularyModel* pModel, QObject* pParent = 0);

	virtual ~EmptyTagFilter();
	virtual bool filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const;

public slots:
	void tagSelectionChanged();
private slots:
	/** @brief This slot is connected to a single shot timer, which is started when
	 * the tag selection has changed.
	 *	
	 * It calls filterChanged(). The usage of a timer was neccessary, because QT seems not to
	 * gracefully accept, when filterChanged() is called directly during the evaluation of
	 * filters themselves. 
	 *
	 */
	void onSelectionChangedTimeout();

};

}



#endif
