//
// C++ Implementation: simplescorecalculationstrategy
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "simplescorecalculationstrategy.h"

#include <vector>
#include <iostream>

// NApt
#include <ipackagedb.h>

// NPlugin
#include <packagenotfoundexception.h>




namespace NApt {

int SimpleScoreCalculationStrategy::ScoreInformation::_maximumDescriptionCount = 0;


SimpleScoreCalculationStrategy::SimpleScoreCalculationStrategy(IPackageDB* pPackageDb)
{
	_pPackageDb = pPackageDb;
}


SimpleScoreCalculationStrategy::~SimpleScoreCalculationStrategy()
{
}

/////////////////////////////////////////////////////
// IScoreCalculationStrategy Interface
/////////////////////////////////////////////////////


void SimpleScoreCalculationStrategy::calculateScore(const set<string>& packages)
{
	qDebug("Calculating Score");
	vector<ScoreInformation> scoreInformation;
	scoreInformation.reserve(packages.size());
	// reset the maximum description count
	ScoreInformation::clearMaximumDescriptionCount();
	// collect the relevant information for each package
	for (set<string>::const_iterator it = packages.begin(); it != packages.end(); ++it)
	{
		try
		{
			ScoreInformation si = getScoreInformation(*it, _cs);
			scoreInformation.push_back(si);
		}
		// if the package was not found, add it with a score of 1
		catch (NPlugin::PackageNotFoundException e)
		{
			qDebug("PackageNotFoundException");
			setScore(*it, 1.0f);
		}
	}
	// calculate the scores for each package
	{
		// moved variables out of the loop to increase performance
		const int includeNum = _includePatterns.size();
		const int maxDescriptionCount = ScoreInformation::maximumDescriptionCount();
		for (vector<ScoreInformation>::const_iterator it = scoreInformation.begin(); 
			it != scoreInformation.end(); ++it )
		{
			// calculate the scores (see method description for details)
			const ScoreInformation& si = *it;
			float nameScores = 0.5;
			if (includeNum != 0)
				nameScores *= float((si.getNameCount()) / includeNum);
			float descriptionScores = 0.5f;
			if (maxDescriptionCount != 0)
			 	descriptionScores *= float(si.getDescriptionCount()) / maxDescriptionCount;
			float score = nameScores + descriptionScores;
			setScore(si.package(), score);
			cout << "Adding " << si.package() << " with score " << score <<endl;
		}
	}
}

/////////////////////////////////////////////////////
// Helper Methods
/////////////////////////////////////////////////////


SimpleScoreCalculationStrategy::ScoreInformation SimpleScoreCalculationStrategy::getScoreInformation(const string& package, bool cs)  const
{
	ScoreInformation info(package);
	
	for (QStringList::const_iterator it = _includePatterns.begin(); it != _includePatterns.end(); ++it)
	{
		info.addDescriptionCount(_pPackageDb->getDescriptionCount(package, *it, cs));
		if (_pPackageDb->matchesName(package, *it, cs))
		{
			info.incrementNameCount();
		}
	}
	return info;
}


}
